package de.soldin.gt2jump.test.jumpplugin;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;

public class TestThreadedPlugin 
	implements ThreadedPlugIn 
	{
	public static final String NAME = "Test Threaded Plugin";
	public static final String VERSION = "1.0";
	
	public void initialize(PlugInContext context){

		FeatureInstaller featureInstaller = context.getFeatureInstaller();
		EnableCheckFactory checkFactory = new EnableCheckFactory(context.getWorkbenchContext());

		// create a check object for main menu item
		// conditions must be fulfilled, or item is disabled
		EnableCheck savecheck =  new MultiEnableCheck()
			.add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck());
		
		// add item to main menu 'Test'	with a check object	
		featureInstaller.addMainMenuItem(
			this,
			"Test",
			NAME,
			null,
			savecheck);

		// add item to category popup menu with a check object
		context.getFeatureInstaller().addPopupMenuItem(
			context.getWorkbenchContext().getWorkbench().getFrame().getCategoryPopupMenu(),
			this,
			NAME,
			false,
			null,
			new MultiEnableCheck().add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1))
		);
		
		// add item to layer popup menu w/o conditions
		featureInstaller.addPopupMenuItem(
			context.getWorkbenchContext().getWorkbench().getFrame().getLayerNamePopupMenu(),
			this,
			NAME,
			false,
			IconLoader.icon("Palette.gif"),
			new MultiEnableCheck()
		);

		// tell everybody	
		System.out.println(getName()+" initialize");
	}
	
  public boolean execute(PlugInContext context) throws Exception {
	
		// tell everybody	GUI
		context.getWorkbenchFrame().getOutputFrame().createNewDocument();
		context.getWorkbenchFrame().getOutputFrame().addText(getName()+" execute");
		context.getWorkbenchFrame().getOutputFrame().surface();
		
		// tell everybody	Commandline
		System.out.println(getName()+" execute");
		
		return true;
  }

	public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
		monitor.allowCancellationRequests();

		for (int i = 0; !monitor.isCancelRequested() && i < 1000; i++) {
			Thread.sleep(1000);
			// tell everybody	GUI
			monitor.report(getName()+"#run "+new Integer(i).toString());
			// tell everybody	Commandline
			System.out.println(getName()+"#run "+new Integer(i).toString());
		} 
	}

	public String getName() {
		return NAME;
	}
	
}
