package de.soldin.gt2jump.test.gt2shapefile;

import javax.swing.JFileChooser;

import com.vividsolutions.jump.io.JUMPReader;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.InstallStandardDataSourceQueryChoosersPlugIn;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.plugin.Extension;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;

public class InstallGT2ShapefileExtension 
	extends Extension 
	implements PlugIn
	{

		public void configure(PlugInContext context) throws Exception {
			this.initialize(context);
		}
		
		public String getName(){
			return "GT2 Shapefile Reader/Writer";
		}
/*
    private void addFileDataSourceQueryChoosers(
        JUMPReader reader,
        JUMPWriter writer,
        final String description,
        //Blackboard blackboard,
        WorkbenchContext wbc,
        Class readerWriterDataSourceClass) {
        DataSourceQueryChooserManager.get(
            blackboard)
                .addLoadDataSourceQueryChooser(new LoadFileDataSourceQueryChooser(
                    readerWriterDataSourceClass,
                    description,
										InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass),
                    wbc) {
            protected void addFileFilters(JFileChooser chooser) {
                super.addFileFilters(chooser);
                InstallStandardDataSourceQueryChoosersPlugIn.addCompressedFileFilter(
                    description,
                    chooser);
            }
        }).addSaveDataSourceQueryChooser(
            new SaveFileDataSourceQueryChooser(
                readerWriterDataSourceClass,
                description,
								InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass),
                wbc));
    }
*/
    public void initialize(final PlugInContext context) throws Exception {
      Blackboard blackboard =
          context.getWorkbenchContext().getWorkbench().getBlackboard();
/*
			addFileDataSourceQueryChoosers(
				null,
				null ,
				"GT2 Shapefile",
				context.getWorkbenchContext(),
				GT2ShapefileReaderWriter.Shapefile.class);
*/				
			DataSourceQueryChooserManager.get(
					context.getWorkbenchContext().getBlackboard())
							.addLoadDataSourceQueryChooser(new LoadFileDataSourceQueryChooser(
									GT2ShapefileReaderWriter.Shapefile.class,
									"GT2 Shapefile",
									InstallStandardDataSourceQueryChoosersPlugIn.extensions(GT2ShapefileReaderWriter.Shapefile.class),
									context.getWorkbenchContext()) {
					protected void addFileFilters(JFileChooser chooser) {
							super.addFileFilters(chooser);
							InstallStandardDataSourceQueryChoosersPlugIn.addCompressedFileFilter(
									"GT2 Shapefile",
									chooser);
					}
			}).addSaveDataSourceQueryChooser(
					new SaveFileDataSourceQueryChooser(
							GT2ShapefileReaderWriter.Shapefile.class,
							"GT2 Shapefile",
							InstallStandardDataSourceQueryChoosersPlugIn.extensions(GT2ShapefileReaderWriter.Shapefile.class),
							context.getWorkbenchContext()));

    }

		public boolean execute(PlugInContext arg0) throws Exception {
			return false;
		}

}
