package de.soldin.gt2jump.test.gpstool;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

import org.dinopolis.gpstool.gpsinput.GPSDataProcessor;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.GPSSerialDevice;
import org.dinopolis.gpstool.gpsinput.nmea.GPSNmeaDataProcessor;

//----------------------------------------------------------------------
/**
 * Simplified GPSTool - demonstrates the usage of the GPS Java API
 */

public class GPSToolSimple {
	protected GPSDataProcessor gps_data_processor;
	protected GPSDevice gps_device;
	Hashtable environment = new Hashtable();

	public GPSToolSimple(String[] arguments) {

		// Set default values
		String filename = null;
		String serial_port_name = null;
		int serial_port_speed = -1;

		// Define a file
//		environment.put(GPSFileDevice.PATH_NAME_KEY,ClassLoader.getSystemResource("MD_NMEA.txt").getPath());
//		gps_device = new GPSFileDevice();

		// Define serial port
		serial_port_name = "COM4";
		serial_port_speed = 4800;
		if (serial_port_name != null)
			environment.put(GPSSerialDevice.PORT_NAME_KEY, serial_port_name);
		if (serial_port_speed > -1)
			environment.put(GPSSerialDevice.PORT_SPEED_KEY,	new Integer(serial_port_speed));
		gps_device = new GPSSerialDevice();

		// define ONE processor 
		//gps_data_processor = new GPSGarminDataProcessor();
		//gps_data_processor = new GPSSirfDataProcessor();
		gps_data_processor = new GPSNmeaDataProcessor();

		try {
			// set params needed to open device (file,serial, ...):
			gps_device.init(environment);
			// connect device and data processor:
			gps_data_processor.setGPSDevice(gps_device);

			// start receiving
			gps_data_processor.open();

			// use progress listener to be informed about the number
			// of packages to download
			//gps_data_processor.addProgressListener(this);

			// Create a listener that prints out only
	 PropertyChangeListener listener = 
		 new PropertyChangeListener(){
			 public void propertyChange(PropertyChangeEvent event) {
				 System.out.println(event.getPropertyName()+": "+event.getNewValue());
			 }
		 };

			gps_data_processor.addGPSDataChangeListener(listener);

			// don't quit now,, let's wait and receive some first
			Thread.sleep(200000);

			// Requests the gps device to send changes periodically. Device may ignore it.
			gps_data_processor.startSendPositionPeriodically(1000L);

			// close device and processor:
			gps_data_processor.close();
		} catch (GPSException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

	}

	public static void main(String[] arguments) {
		new GPSToolSimple(arguments);
	}
}
