package de.soldin.gt2jump.test.gps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

import org.dinopolis.gpstool.gpsinput.GPSDataProcessor;
import org.dinopolis.gpstool.gpsinput.GPSDevice;
import org.dinopolis.gpstool.gpsinput.GPSException;
import org.dinopolis.gpstool.gpsinput.GPSSerialDevice;
import org.dinopolis.gpstool.gpsinput.nmea.GPSNmeaDataProcessor;

/**
 * @author ed
 *
 * Simple example of how to use the org.dinopolis.gpstool package
 * to retrieve location and altitude
 */
public class GPSTest {

	public GPSTest() throws Exception{
		// Define device to read data from
		GPSDevice gps_device;
		Hashtable environment = new Hashtable();
		environment.put(GPSSerialDevice.PORT_NAME_KEY,"COM4");
		environment.put(GPSSerialDevice.PORT_SPEED_KEY,new Integer(4800));
		gps_device = new GPSSerialDevice();
		gps_device.init(environment);
		
		// Define a processor
		GPSDataProcessor gps_data_processor = new GPSNmeaDataProcessor();
		gps_data_processor.setGPSDevice(gps_device);
		gps_data_processor.open();
		
		// Create a listener that prints out only
		PropertyChangeListener listener = 
			new PropertyChangeListener(){
				public void propertyChange(PropertyChangeEvent event) {
					System.out.println(event.getPropertyName()+": "+event.getNewValue());
				}
			};
		
		// Add the listener for selected events only
		gps_data_processor.addGPSDataChangeListener(GPSDataProcessor.LOCATION, listener);
		gps_data_processor.addGPSDataChangeListener(GPSDataProcessor.ALTITUDE, listener);
		
		// Keep process alive until some key gets pushed
		while (System.in.available()<1) {
			Thread.sleep(1000);
		}
	}
	
	public static void main(String[] args) throws Exception{
		new GPSTest();	
	}

}
