/**
 * @(#)GT2WriterPlugin.java	29.06.2004
 *
 * Copyright 2004 Edgar Soldin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package de.soldin.gt2jump.readwrite;

import javax.swing.JPopupMenu;

import org.geotools.data.DataSourceMetaData;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;

/**
 * The write specific derivation of {@link GT2ReaderWriterPlugin}
 */
public class GT2WriterPlugin extends GT2ReaderWriterPlugin{
	private final String NAME = "Save Dataset with GT2";

	public String getName(){ return NAME; }
	
	public void initialize(PlugInContext context){
		FeatureInstaller featureInstaller = context.getFeatureInstaller();

		EnableCheckFactory checkFactory = new EnableCheckFactory(context.getWorkbenchContext());
		EnableCheck savecheck =  new MultiEnableCheck()
			.add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck())
			.add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));

		featureInstaller.addMainMenuItem(
			this,
			"File",
			NAME,
			null,
			savecheck);

		JPopupMenu layerNamePopupMenu =
			context.getWorkbenchContext().getWorkbench().getFrame().getLayerNamePopupMenu();
		context.getFeatureInstaller().addPopupMenuItem(
			layerNamePopupMenu,
			this,
			NAME,
			false,
			null,
			savecheck);	
	}

	public void exec(TaskMonitor monitor, PlugInContext context) throws Exception {
		//this.NAME = GT2ReaderWriterExtension.SAVE;
		//super.run(monitor,context);
		//System.out.println(getName()+" run");

		if (this.isCancelled()) return;
		// check supported write modes		
		String sup_text = "Datasource supports... ";	
		StringBuffer mode_text = new StringBuffer();
		report(mode_text.toString());
		DataSourceMetaData ds_m = ds.getMetaData();
		boolean writesupport = false;
		if (ds_m.supportsSetFeatures()){
			writesupport = true;
			mode_text.append(" setFeatures()");
			report(sup_text+mode_text.toString());
		}
		if (ds_m.supportsAdd()){
			writesupport = true;
			mode_text.append(" addFeatures()");
			report(sup_text+mode_text.toString());
		}				
		if (ds_m.supportsModify()){
			writesupport = true;
			mode_text.append(" modifyFeatures()");
			report(sup_text+mode_text.toString());
		}
				
		if (!writesupport){
			writesupport = true;
			mode_text.append(" currently no write operation supported.");
			context.getLayerViewPanel().getContext().warnUser("Write failed! Datasource does not currently support writing.");
			report(mode_text.toString());
			return;
		}else{
			if (this.isCancelled()) return;			
			report("Retrieve dataset from layer...");			
			Layer layer = context.getSelectedLayer(0);
			if (layer==null){
				context.getLayerViewPanel().getContext().warnUser("No layer selected!");			
				return;
			}
			FeatureCollection features = layer.getFeatureCollectionWrapper().getUltimateWrappee(); 

			if (this.isCancelled()) return;		
			report("Convert dataset...");
			org.geotools.feature.FeatureCollection gt2_features = FCConverter.convert(features);	

			if (this.isCancelled()) return;			
			report("Save dataset...");			
			try{
				this.ds.setFeatures(gt2_features);
			}catch(UnsupportedOperationException e){
				try{
					this.ds.addFeatures(gt2_features);
				}catch(UnsupportedOperationException e1){
					context.getLayerViewPanel().getContext().warnUser("Write failed! Reason setF(),add() are unsupported.");					
				}
			}		
		}

	}
	
	/*public String getName() {
		return GT2ReaderWriterPlugin.SAVE;
	}*/
}