/**
 * @(#)GT2ReaderWriterPlugin.java	29.06.2004
 *
 * Copyright 2004 Edgar Soldin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package de.soldin.gt2jump.readwrite;

import java.awt.Component;
import java.awt.Point;

import org.geotools.data.DataSource;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.TaskFrame;

/**
 * This <code>abstract</code> class is the base for {@link de.soldin.gt2jump.readwrite.GT2ReaderPlugin} and
 * {@link de.soldin.gt2jump.readwrite.GT2WriterPlugin} as it contains the common
 * routines eg. the choice of the gt2 io module per dialog or similar actions.
 * <p>
 * The Plugin is threaded, but can't take advance from it as the task monitor until now
 * June 2004 is modal, and therefore doesnt allow other action while it is showing. 
 * As Jon (the jump author) told me in the users mailing listt, jump is not threadsafe 
 * by now, and therefore he'll keep this way until it is.
 * </p>
 */
public abstract class GT2ReaderWriterPlugin 
	//extends ThreadedBasePlugIn
	implements ThreadedPlugIn
	{
	protected GT2DatasourceFactoryChooser f_ch;
	protected TaskMonitor monitor;
	protected PlugInContext context;
	protected DataSource ds;
	protected String ds_name;
	
	abstract public void initialize(PlugInContext context);
	
	//public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
	public boolean execute(PlugInContext context) throws Exception {
		//System.out.println(getName()+" run");
		
		//this.report("Open datasource chooser.");
		if (this.f_ch==null) this.f_ch = new GT2DatasourceFactoryChooser(context.getWorkbenchFrame(),getName());
		// position dialog
		Point location;
		Component frame = context.getActiveInternalFrame();
		if (frame instanceof TaskFrame){
			location = frame.getLocationOnScreen();
		}else{
			frame = context.getWorkbenchFrame();
			location = frame.getLocationOnScreen();		
		}
		location.translate(125,25);
		this.f_ch.dialog.setLocation(location);

		do{
			try{
				this.ds = this.f_ch.choose();
				this.ds_name = this.f_ch.getDSName();
			}catch (Exception exc){
				context.getErrorHandler().handleThrowable(exc);
			}catch (Error err){
				context.getErrorHandler().handleThrowable(err);
			}
			//System.out.println(this.ds+" "+isCancelled());
		}while( this.ds==null && !isCancelled() );
		
		// nothing to do w/o datasource ? Yeah, if its cancelled
		if ( this.ds==null && !isCancelled() ){
			context.getLayerViewPanel().getContext().warnUser("No valid datasource. Please check parameters!");
			return false;
		}else{
			return true;
		}
			
	}
	
	protected void report(String msg){
		if (monitor!=null) monitor.report(msg);
	}
	
	protected boolean isCancelled(){
		boolean thread_cancelled = this.monitor==null? false : this.monitor.isCancelRequested();
		return thread_cancelled || this.f_ch.isCancelled();
	}

	public void run(TaskMonitor monitor, PlugInContext context) throws Exception{
		this.monitor = monitor;
		this.monitor.allowCancellationRequests();
		this.context = context;
		exec(monitor,context);
		this.monitor = null;
		this.context = null;
	}
	
	abstract public void exec(TaskMonitor arg0, PlugInContext arg1) throws Exception ;
	
	abstract public String getName();
}
