/**
 * @(#)GT2ReaderWriterExtension.java	29.06.2004
 *
 * Copyright 2004 Edgar Soldin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package de.soldin.gt2jump.readwrite;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Vector;

import com.vividsolutions.jump.workbench.plugin.Extension;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;

/**
 * As usual the extension installs/initializes {@link GT2ReaderPlugin} and
 * {@link GT2WriterPlugin}.
 * <p>
 * A specialty is the {@link #createLoader()} method. Check it out.
 * </p>
 */
public class GT2ReaderWriterExtension 
	extends Extension
	{
	private static final String NAME = "GT2 Reader&Writer";
	private static final String VERSION = "0.1a";

	public void configure(PlugInContext context) throws Exception {
		context.getFeatureInstaller().addMenuSeparator("File");
		new GT2ReaderPlugin().initialize(context);
		new GT2WriterPlugin().initialize(context);	
	}
	
	public String getVersion(){ return VERSION; }
	
	public String getName()   {	return NAME; }

	/**
	 * This is thought of as a way to dynamically load the gt2 readerwriter modules
	 * from a directory of choice. this way they don't have reside in the general classpath
	 * but can be put in separate directory. 
	 * <p>
	 * The property "user.dir" works for windows, i doubt it'll do for linux/unix.
	 * </p>
	 * 
	 * @return a classloader object, containing all available jars in the specified directory 
	 */
	public static ClassLoader createLoader(){
			final String SEP = System.getProperty("file.separator");
			String mod_dir = SEP+"lib"+SEP+"ext"+SEP+"readwrite";
			File workingDir = new File(System.getProperty("user.dir"));
			
			System.out.println("Working Dir: "+workingDir.getPath());
			
			
			File extensionDir = new File(workingDir.getPath()+mod_dir);
			if (!extensionDir.exists())
				extensionDir = new File(workingDir.getPath()+SEP+".."+mod_dir);
			
			System.out.println("Extension Dir: "+extensionDir.getPath());			
			
			File[] entries = extensionDir.listFiles();
			Collection urls = new Vector();
			try {
				urls.add(extensionDir.toURL());
			} catch (MalformedURLException e1) {}
			for (int i = 0; entries != null && i < entries.length; i++) {
				try {
					urls.add(entries[i].toURL());
				} catch (MalformedURLException e) { e.printStackTrace(); }
			}
			
			System.out.println("ExtDir contains: "+urls.toString());
		
			return new URLClassLoader((URL[])urls.toArray(new URL[]{}));	
	}

}