/**
 * @(#)GT2ReaderPlugin.java	29.06.2004
 *
 * Copyright 2004 Edgar Soldin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package de.soldin.gt2jump.readwrite;

import java.util.Collection;

import javax.swing.JPopupMenu;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;


/**
 * The read specific derivation of {@link GT2ReaderWriterPlugin}
 */
public class GT2ReaderPlugin extends GT2ReaderWriterPlugin{
	private final String NAME = "Load Dataset with GT2";
	
	public String getName(){ return NAME; }
		
	public void initialize(PlugInContext context){
		FeatureInstaller featureInstaller = context.getFeatureInstaller();
		
		featureInstaller.addMainMenuItem(
			this,
			"File",
			NAME,
			null,
			null);

		JPopupMenu categoryPopups =
			context.getWorkbenchContext().getWorkbench().getFrame().getCategoryPopupMenu();
		context.getFeatureInstaller().addPopupMenuItem(
			categoryPopups,
			this,
			NAME,
			false,
			null,
			null);
	}

	public void exec(TaskMonitor monitor, PlugInContext context) throws Exception {

		if (this.isCancelled()) return;
		report("Detect category...");	
		Collection categories = context.getLayerNamePanel().getSelectedCategories();
		Category category;
		if (categories.isEmpty()){
			categories = context.getLayerManager().getCategories();
			if (categories.isEmpty()){
				context.getLayerViewPanel().getContext().warnUser("Please create a category to put dataset in!");
				return;
			}else{
				context.getLayerViewPanel().getContext().warnUser("No category selected! Put dataset in first category available.");
				category = (Category)categories.toArray()[0];
			}
		}else{
			category = (Category)categories.toArray()[0];
		}
		
		if (this.isCancelled()) return;
		report("Load Dataset from '"+ds_name+"' now...");		
		org.geotools.feature.FeatureCollection gt2_features = ds.getFeatures();

		if (this.isCancelled()) return;		
		report("Convert Dataset now...");	
		FeatureCollection features = FCConverter.convert(gt2_features);


		if (this.isCancelled()) return;
		report("Add Layer now...");
		Layer layer = context.getLayerManager().addLayer(category.getName(), this.ds_name, features);		
		
	}

}

