/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.SchemaException;

public class MysqlGeomColumn {
    public static final int NORMALIZED_STORAGE_TYPE = 0;
    public static final int WKB_STORAGE_TYPE = 1;
    public static final String GEOMETRY_META_NAME = "GEOMETRY_COLUMNS";
    private static final int COLUMN_OFFSET = 2;
    private static Map sqlTypeMap = new HashMap();
    private static final Logger LOGGER = Logger.getLogger("org.geotools.mysql");
    private static GeometryFactory geometryFactory = new GeometryFactory();
    private static WKTReader geometryReader = new WKTReader(geometryFactory);
    private static Map gidMap = new HashMap();
    private static AttributeTypeFactory attFactory = AttributeTypeFactory.newInstance();
    private String feaTabCatalog;
    private String feaTabSchema;
    private String feaTabName;
    private String feaGeomColumn;
    private String geomTabCatalog;
    private String geomTabSchema;
    private String geomTabName;
    private int storageType;
    private int geomType;
    private int coordDimension;
    private int maxPPR;
    private int spacRefID;
    private FeatureType schema = null;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public MysqlGeomColumn() {
    }

    public MysqlGeomColumn(String feaTabName, String feaGeomColumn, String geomTabName) {
        this.feaTabName = feaTabName;
        this.feaGeomColumn = feaGeomColumn;
        this.geomTabName = geomTabName;
    }

    public MysqlGeomColumn(Connection dbConnection, String feaTableName) throws SQLException, SchemaException {
        this.feaTabName = feaTableName;
        try {
            Statement statement = dbConnection.createStatement();
            String sqlQuery = this.makeGeomSql(feaTableName);
            LOGGER.warning("SQL q = " + sqlQuery);
            ResultSet result = statement.executeQuery(sqlQuery);
            while (result.next()) {
                this.feaTabCatalog = result.getString(1);
                this.feaTabSchema = result.getString(2);
                this.feaGeomColumn = result.getString(4);
                this.geomTabCatalog = result.getString(5);
                this.geomTabSchema = result.getString(6);
                this.geomTabName = result.getString(7);
                this.storageType = result.getInt(8);
                this.geomType = result.getInt(9);
                this.coordDimension = result.getInt(10);
                this.maxPPR = result.getInt(11);
                this.spacRefID = result.getInt(12);
            }
            LOGGER.finer("creating new geometry column with values: " + this.feaTabName + " " + this.feaGeomColumn + " " + this.geomTabName);
            result = statement.executeQuery("SELECT * FROM " + this.geomTabName);
            int gid = 0;
            String wkb = null;
            while (result.next()) {
                gid = result.getInt(1);
                wkb = result.getString(6);
                this.populateData(gid, wkb);
            }
            result.close();
            statement.close();
        }
        catch (SQLException e) {
            LOGGER.warning("Some sort of database connection error: " + e.getMessage());
        }
    }

    private String makeGeomSql(String feaTableName) {
        return "SELECT * FROM GEOMETRY_COLUMNS WHERE F_TABLE_NAME = '" + feaTableName + "';";
    }

    public void populateData(int geomID, String wellKnownText) {
        LOGGER.finer("putting " + wellKnownText + " into gidMap");
        gidMap.put(new Integer(geomID), wellKnownText);
    }

    public void removeData(int geomID) {
        gidMap.remove(new Integer(geomID));
    }

    public Geometry getGeometry(int geomID) throws DataSourceException {
        Geometry returnGeometry = null;
        String wellKnownText = (String)gidMap.get(new Integer(geomID));
        LOGGER.finer("about to create geometry for " + wellKnownText);
        if (wellKnownText == null) {
            return null;
        }
        try {
            returnGeometry = geometryReader.read(wellKnownText);
        }
        catch (ParseException e) {
            LOGGER.finer("Failed to parse the geometry from Mysql: " + e.getMessage());
        }
        return returnGeometry;
    }

    public void setFeaTableCat(String catalog) {
        this.feaTabCatalog = catalog;
    }

    public String getFeaTableCat() {
        return this.feaTabCatalog;
    }

    public void setFeaTableSchema(String schema) {
        this.feaTabSchema = schema;
    }

    public String getFeaTableSchema() {
        return this.feaTabSchema;
    }

    public void setFeaTableName(String name) {
        this.feaTabName = name;
    }

    public String getFeaTableName() {
        return this.feaTabName;
    }

    public void setGeomColName(String name) {
        this.feaGeomColumn = name;
    }

    public String getGeomColName() {
        return this.feaGeomColumn;
    }

    public void setGeomTableCat(String catalog) {
        this.geomTabCatalog = catalog;
    }

    public String getGeomTableCat() {
        return this.geomTabCatalog;
    }

    public void setGeomTableSchema(String schema) {
        this.geomTabSchema = schema;
    }

    public String getGeomTableSchema() {
        return this.geomTabSchema;
    }

    public void setGeomTableName(String name) {
        this.geomTabName = name;
    }

    public String getGeomTableName() {
        return this.geomTabName;
    }

    public void setStorageType(int sType) {
        this.storageType = sType;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setGeomType(int gType) {
        this.geomType = gType;
    }

    public int getGeomType() {
        return this.geomType;
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public void setSchema(FeatureType schema) {
        this.schema = schema;
    }

    public static FeatureType makeSchema(ResultSetMetaData metaData, String geoColumn) throws SQLException, SchemaException {
        String columnName = null;
        Class colClass = null;
        int numCols = metaData.getColumnCount();
        AttributeType[] attributes = new AttributeType[numCols - 1];
        LOGGER.finer("about to loop through cols");
        for (int i = 2; i <= numCols; ++i) {
            columnName = metaData.getColumnName(i);
            LOGGER.finer("reading col: " + i + " named: " + columnName);
            LOGGER.finer("reading col: " + metaData.getColumnTypeName(i));
            if (columnName.equals(geoColumn)) {
                attributes[i - 2] = AttributeTypeFactory.newAttributeType((String)columnName, (Class)(class$com$vividsolutions$jts$geom$Geometry == null ? MysqlGeomColumn.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry));
                continue;
            }
            colClass = (Class)sqlTypeMap.get(metaData.getColumnTypeName(i));
            attributes[i - 2] = AttributeTypeFactory.newAttributeType((String)columnName, (Class)colClass);
        }
        return FeatureTypeFactory.newFeatureType((AttributeType[])attributes, (String)"mysql-feature");
    }

    static {
        sqlTypeMap.put("TINY", Byte.class);
        sqlTypeMap.put("SHORT", Short.class);
        sqlTypeMap.put("INT", Integer.class);
        sqlTypeMap.put("LONG", Integer.class);
        sqlTypeMap.put("LONGLONG", Long.class);
        sqlTypeMap.put("DOUBLE", Double.class);
        sqlTypeMap.put("VARCHAR", String.class);
        sqlTypeMap.put("DECIMAL", String.class);
        sqlTypeMap.put("CHAR", String.class);
        sqlTypeMap.put("TEXT", String.class);
        sqlTypeMap.put("BLOB", String.class);
        sqlTypeMap.put("FLOAT", Float.class);
    }
}

