/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.Query;
import org.geotools.data.mysql.MysqlGeomColumn;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;

public class MysqlDataSource
extends AbstractDataSource
implements DataSource {
    private static final int COLUMN_OFFSET = 2;
    private static final Logger LOGGER = Logger.getLogger("org.geotools.mysql");
    private static WKTWriter geometryWriter = new WKTWriter();
    private int maxFeatures = 500;
    private javax.sql.DataSource db;
    private MysqlGeomColumn geomDataCol;
    private String tableName;
    private FeatureType schema = null;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public MysqlDataSource(javax.sql.DataSource db, String feaTableName) {
        this.db = db;
        this.tableName = feaTableName;
        try {
            Connection dbConnection = db.getConnection();
            this.geomDataCol = new MysqlGeomColumn(dbConnection, feaTableName);
            dbConnection.close();
        }
        catch (SQLException e) {
            LOGGER.warning("Some sort of database connection error: " + e.getMessage());
        }
        catch (SchemaException e) {
            LOGGER.warning("problems creating the schema" + (Object)((Object)e));
        }
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        Filter filter = query.getFilter();
        this.maxFeatures = query.getMaxFeatures();
        try {
            LOGGER.finer("about to make connection");
            Connection dbConnection = this.db.getConnection();
            Statement statement = dbConnection.createStatement();
            ResultSet result = statement.executeQuery(this.makeImportSql(filter));
            if (this.schema == null) {
                try {
                    this.schema = MysqlGeomColumn.makeSchema(result.getMetaData(), this.geomDataCol.getGeomColName());
                }
                catch (Exception e) {
                    LOGGER.warning("Had problems creating the Schema..." + e.getMessage());
                }
            }
            LOGGER.finer("about to prepare feature reading");
            Object[] attributes = new Object[this.schema.getAttributeCount()];
            AttributeType[] attributeTypes = this.schema.getAttributeTypes();
            int resultCounter = 0;
            int numAttr = this.schema.getAttributeCount();
            while (result.next() && resultCounter < this.maxFeatures) {
                LOGGER.finer("reading feature: " + resultCounter);
                String featureID = result.getString(1);
                for (int col = 0; col < numAttr; ++col) {
                    LOGGER.finer("reading attribute: " + col);
                    if (attributeTypes[col].isGeometry()) {
                        Geometry geom = this.geomDataCol.getGeometry(result.getInt(col + 2));
                        if (geom == null) {
                            throw new DataSourceException("inconsistent database, the gid did not find valid geometry data");
                        }
                        attributes[col] = geom;
                        continue;
                    }
                    attributes[col] = result.getObject(col + 2);
                }
                Feature curFeature = this.schema.create(attributes, featureID);
                if (filter != null && !filter.contains(curFeature)) continue;
                collection.add((Object)curFeature);
                LOGGER.finest("adding feature: " + curFeature);
                ++resultCounter;
            }
            result.close();
            statement.close();
            dbConnection.close();
        }
        catch (SQLException e) {
            LOGGER.warning("Some sort of database connection error: " + e.getMessage());
        }
        catch (IllegalAttributeException e) {
            LOGGER.warning("Had problems creating the feature: " + e.getMessage());
        }
    }

    public Set addFeatures(FeatureCollection features) throws DataSourceException {
        Object[] featureArr = new Feature[features.size()];
        String sql = "";
        String geomSql = "";
        String attrValue = "";
        Geometry curGeom = null;
        featureArr = (Feature[])features.toArray(featureArr);
        this.schema = featureArr[0].getFeatureType();
        AttributeType[] attributeTypes = this.schema.getAttributeTypes();
        int numAttributes = attributeTypes.length;
        Object[] curAttributes = new Object[this.schema.getAttributeCount()];
        try {
            Connection dbConnection = this.db.getConnection();
            Statement statement = dbConnection.createStatement();
            for (int i = 0; i < featureArr.length; ++i) {
                curAttributes = featureArr[i].getAttributes(curAttributes);
                sql = "INSERT INTO " + this.geomDataCol.getFeaTableName() + " VALUES(";
                String featureID = featureArr[i].getID();
                sql = sql + this.addQuotes(featureID) + ", ";
                for (int j = 0; j < curAttributes.length; ++j) {
                    if (attributeTypes[j].isGeometry()) {
                        int gid = this.createGID(featureID);
                        curGeom = (Geometry)curAttributes[j];
                        geomSql = this.makeGeomSql(curGeom, gid);
                        this.geomDataCol.populateData(gid, geometryWriter.write(curGeom));
                        attrValue = new Integer(gid).toString();
                    } else {
                        attrValue = this.addQuotes(curAttributes[j]);
                    }
                    sql = sql + attrValue;
                    if (j >= curAttributes.length - 1) continue;
                    sql = sql + ", ";
                }
                sql = sql + ")";
                LOGGER.finer("this sql statement = " + sql);
                statement.executeUpdate(geomSql);
                statement.executeUpdate(sql);
            }
            statement.close();
            dbConnection.close();
        }
        catch (SQLException e) {
            LOGGER.warning("Some sort of database connection error: " + e.getMessage());
        }
        return null;
    }

    private int createGID(Object featureID) {
        return featureID.hashCode();
    }

    private String addQuotes(Object value) {
        String retString = "'" + value.toString() + "'";
        return retString;
    }

    private String makeImportSql(Filter filter) {
        return "SELECT * FROM " + this.tableName + ";";
    }

    private String makeDelGeomSql(int gid) {
        return "DELETE FROM " + this.geomDataCol.getGeomTableName() + " WHERE " + "GID = " + gid;
    }

    private String makeGeomSql(Geometry curGeom, int geomID) {
        Envelope env = curGeom.getEnvelopeInternal();
        double xMin = env.getMinX();
        double yMin = env.getMinY();
        double xMax = env.getMaxX();
        double yMax = env.getMaxY();
        String returnSql = "INSERT INTO " + this.geomDataCol.getGeomTableName() + " VALUES(" + geomID + ", " + xMin + ", " + yMin + ", " + xMax + ", " + yMax + ", '" + geometryWriter.write(curGeom) + "')";
        LOGGER.finer("to put our location in we say: " + returnSql);
        return returnSql;
    }

    private String makeModifySql(AttributeType type, Object value, Feature feature) {
        String id = this.addQuotes(feature.getID());
        String sql = "UPDATE " + this.geomDataCol.getFeaTableName() + " SET " + type.getName() + " = " + this.addQuotes(value) + " WHERE ID = " + id;
        return sql;
    }

    private Feature[] getFilteredFeatures(Filter filter) throws DataSourceException {
        FeatureCollection collection = this.getFeatures(filter);
        return (Feature[])collection.toArray((Object[])new Feature[collection.size()]);
    }

    public void removeFeatures(Filter filter) throws DataSourceException {
        String sql = "";
        String fid = null;
        int gid = 0;
        String feaTabName = this.geomDataCol.getFeaTableName();
        Feature[] featureArr = this.getFilteredFeatures(filter);
        this.schema = featureArr[0].getFeatureType();
        String gidName = this.schema.getDefaultGeometry().getName();
        try {
            Connection dbConnection = this.db.getConnection();
            Statement statement = dbConnection.createStatement();
            Statement stmtR = dbConnection.createStatement();
            Object[] curAttributes = new Object[this.schema.getAttributeCount()];
            for (int i = 0; i < featureArr.length; ++i) {
                curAttributes = featureArr[i].getAttributes(curAttributes);
                String fidValue = featureArr[i].getID();
                fid = this.addQuotes(fidValue);
                gid = this.createGID(fidValue);
                sql = "DELETE FROM " + feaTabName + " WHERE ID = " + fid;
                LOGGER.finer("our delete says : " + sql);
                statement.executeUpdate(sql);
                stmtR.executeUpdate(this.makeDelGeomSql(gid));
                this.geomDataCol.removeData(gid);
            }
            statement.close();
            dbConnection.close();
        }
        catch (SQLException e) {
            LOGGER.warning("Error with sql " + e.getMessage());
        }
    }

    public void modifyFeatures(AttributeType type, Object value, Filter filter) throws DataSourceException {
        Feature[] featureArr = this.getFilteredFeatures(filter);
        try {
            Connection dbConnection = this.db.getConnection();
            Statement stmt = dbConnection.createStatement();
            for (int i = 0; i < featureArr.length; ++i) {
                if ((class$com$vividsolutions$jts$geom$Geometry == null ? MysqlDataSource.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(type.getType())) {
                    if (!featureArr[i].getID().equals("6")) continue;
                    int gid = this.createGID(featureArr[i].getID());
                    stmt.executeUpdate(this.makeDelGeomSql(gid));
                    stmt.executeUpdate(this.makeGeomSql((Geometry)value, gid));
                    continue;
                }
                stmt.executeUpdate(this.makeModifySql(type, value, featureArr[i]));
            }
        }
        catch (SQLException e) {
            LOGGER.warning("sql exception: " + e);
        }
    }

    public FeatureType getSchema() throws DataSourceException {
        return this.schema;
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport mysqlMeta = new AbstractDataSource.MetaDataSupport();
        mysqlMeta.setSupportsAdd(true);
        mysqlMeta.setSupportsRemove(true);
        mysqlMeta.setSupportsModify(true);
        return mysqlMeta;
    }
}

