/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.AttributeReader;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.QueryDataObserver;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.mysql.MySQLAttributeReader;
import org.geotools.data.mysql.MySQLAttributeWriter;
import org.geotools.data.mysql.MySQLConnectionFactory;
import org.geotools.data.mysql.MySQLGeometryAttributeWriter;
import org.geotools.data.mysql.MySQLSQLBuilder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;

public class MySQLDataStore
extends JDBCDataStore {
    private static WKTWriter geometryWriter = new WKTWriter();

    public MySQLDataStore(ConnectionPool connectionPool) throws IOException {
        super(connectionPool);
    }

    public MySQLDataStore(ConnectionPool connectionPool, String databaseSchemaName) throws IOException {
        super(connectionPool, databaseSchemaName);
    }

    public MySQLDataStore(ConnectionPool connectionPool, String databaseSchemaName, String namespace) throws IOException {
        super(connectionPool, JDBCDataStoreConfig.createWithNameSpaceAndSchemaName((String)namespace, (String)databaseSchemaName));
    }

    public static MySQLDataStore getInstance(String host, String schema, String username, String password) throws IOException, SQLException {
        return MySQLDataStore.getInstance(host, new Integer(3306), schema, username, password);
    }

    public static MySQLDataStore getInstance(String host, Integer port, String schema, String username, String password) throws IOException, SQLException {
        return new MySQLDataStore(new MySQLConnectionFactory(host, port, schema).getConnectionPool(username, password));
    }

    protected AttributeReader createGeometryReader(AttributeType attrType, QueryData queryData, int index) throws IOException {
        return new MySQLAttributeReader(attrType, queryData, index);
    }

    protected AttributeWriter createGeometryWriter(AttributeType attrType, QueryData queryData, int index) throws IOException {
        return new MySQLGeometryAttributeWriter(attrType, queryData, index);
    }

    protected AttributeWriter createResultSetWriter(AttributeType[] attrType, QueryData queryData, int startIndex, int endIndex) {
        return new MySQLAttributeWriter(attrType, queryData, startIndex, endIndex);
    }

    protected JDBCDataStore.JDBCFeatureWriter createFeatureWriter(FeatureReader fReader, AttributeWriter writer, QueryData queryData) throws IOException {
        return new MySQLFeatureWriter(fReader, writer, queryData);
    }

    private String makeDeleteSql(Feature feature, JDBCDataStore.FeatureTypeInfo ftInfo) {
        String tableName = ftInfo.getFeatureTypeName();
        String keyName = ftInfo.getFidColumnName();
        String fid = feature.getID();
        int split = fid.indexOf(46);
        if (split != -1 && fid.substring(0, split).equals(tableName)) {
            fid = fid.substring(split + 1);
        }
        return "DELETE FROM " + tableName + " WHERE " + keyName + " = " + fid;
    }

    private String makeInsertSql(Feature feature, JDBCDataStore.FeatureTypeInfo ftInfo) {
        boolean isAutoIncrement;
        String tableName = ftInfo.getFeatureTypeName();
        StringBuffer sql = new StringBuffer("INSERT INTO " + tableName + " (");
        FeatureType featureSchema = feature.getFeatureType();
        AttributeType[] types = featureSchema.getAttributeTypes();
        boolean bl = isAutoIncrement = ftInfo.getFidColumnName() != null;
        if (!isAutoIncrement) {
            sql.append(ftInfo.getFidColumnName());
            sql.append(", ");
        }
        for (int i = 0; i < types.length; ++i) {
            sql.append(types[i].getName());
            sql.append(i < types.length - 1 ? ", " : ") ");
        }
        sql.append("VALUES (");
        Object[] attributes = feature.getAttributes(null);
        if (!isAutoIncrement) {
            char ch;
            String fid = feature.getID();
            int split = fid.indexOf(46);
            if (split != -1 && fid.substring(0, split).equals(tableName)) {
                fid = fid.substring(split + 1);
            }
            if (Character.isLetter(ch = fid.charAt(0)) || ch == '_') {
                sql.append("'");
                sql.append(fid);
                sql.append("'");
            } else if (Character.isDigit(ch)) {
                try {
                    long number = Long.parseLong(fid);
                    sql.append(number);
                }
                catch (NumberFormatException badNumber) {
                    sql.append(fid);
                }
            } else {
                sql.append(fid);
            }
            sql.append(", ");
        }
        for (int j = 0; j < attributes.length; ++j) {
            if (types[j].isGeometry()) {
                String geomName = types[j].getName();
                int srid = ftInfo.getSRID(geomName);
                String geoText = this.getGeometryText((Geometry)attributes[j], srid);
                sql.append(geoText);
            } else {
                String attrValue = this.addQuotes(attributes[j]);
                sql.append(attrValue);
            }
            if (j >= attributes.length - 1) continue;
            sql.append(", ");
        }
        sql.append(");");
        return sql.toString();
    }

    private String addQuotes(Object value) {
        String retString;
        if (value != null) {
            StringBuffer buf = new StringBuffer();
            String str = value.toString();
            for (int i = 0; i < str.length(); ++i) {
                char thisChar = str.charAt(i);
                buf.append(thisChar);
                if (thisChar != '\'') continue;
                buf.append('\'');
            }
            retString = "'" + buf.toString() + "'";
        } else {
            retString = "NULL";
        }
        return retString;
    }

    private String getGeometryText(Geometry geom, int srid) {
        if (geom == null) {
            return "NULL";
        }
        String geoText = geometryWriter.write(geom);
        String sql = null;
        sql = GeometryCollection.class.isAssignableFrom(geom.getClass()) ? (MultiPoint.class.isAssignableFrom(geom.getClass()) ? "MultiPointFromText" : (MultiLineString.class.isAssignableFrom(geom.getClass()) ? "MultiLineStringFromText" : (MultiPolygon.class.isAssignableFrom(geom.getClass()) ? "MultiPolygonFromText" : "GeometryCollectionFromText"))) : (Point.class.isAssignableFrom(geom.getClass()) ? "PointFromText" : (LineString.class.isAssignableFrom(geom.getClass()) ? "LineStringFromText" : (Polygon.class.isAssignableFrom(geom.getClass()) ? "PolygonFromText" : "GeometryFromText")));
        sql = sql + "('" + geoText + "', " + srid + ")";
        return sql;
    }

    public FeatureWriter getFeatureWriter(String typeName) throws IOException {
        return this.getFeatureWriter(typeName, Filter.NONE, Transaction.AUTO_COMMIT);
    }

    public FeatureWriter getFeatureWriterAppend(String typeName) throws IOException {
        return this.getFeatureWriterAppend(typeName, Transaction.AUTO_COMMIT);
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws SQLException, DataSourceException {
        int COLUMN_NAME = 4;
        int DATA_TYPE = 5;
        int TYPE_NAME = 6;
        int dataType = rs.getInt(5);
        if (dataType == 1111) {
            String typeName = rs.getString(6);
            String typeNameLower = typeName.toLowerCase();
            if ("geometry".equals(typeNameLower)) {
                return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)Geometry.class);
            }
            if ("point".equals(typeNameLower)) {
                return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)Point.class);
            }
            if ("linestring".equals(typeNameLower)) {
                return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)LineString.class);
            }
            if ("polygon".equals(typeNameLower)) {
                return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)Polygon.class);
            }
            if ("multipoint".equals(typeNameLower)) {
                return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)MultiPoint.class);
            }
            if ("multilinestring".equals(typeNameLower)) {
                return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)MultiLineString.class);
            }
            if ("multipolygon".equals(typeNameLower)) {
                return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)MultiPolygon.class);
            }
            if ("geometrycollection".equals(typeNameLower)) {
                return AttributeTypeFactory.newAttributeType((String)rs.getString(4), (Class)GeometryCollection.class);
            }
            return super.buildAttributeType(rs);
        }
        return super.buildAttributeType(rs);
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        return new MySQLSQLBuilder();
    }

    protected class MySQLFeatureWriter
    extends JDBCDataStore.JDBCFeatureWriter {
        public MySQLFeatureWriter(FeatureReader fReader, AttributeWriter writer, QueryData queryData) throws IOException {
            super((JDBCDataStore)MySQLDataStore.this, fReader, writer, queryData);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void doInsert(Feature current) throws IOException, SQLException {
            Statement statement = null;
            try {
                try {
                    statement = this.queryData.getConnection().createStatement();
                    String sql = MySQLDataStore.this.makeInsertSql(current, this.queryData.getFeatureTypeInfo());
                    System.out.println("going to insert:");
                    System.out.println(sql);
                    statement.executeUpdate(sql);
                }
                catch (SQLException sqle) {
                    String msg = "SQL Exception writing geometry column";
                    throw new DataSourceException(msg, (Throwable)sqle);
                }
                Object var6_5 = null;
                if (statement == null) return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (statement == null) throw throwable;
                try {
                    statement.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException e) {}
            statement.close();
            return;
        }

        public Feature next() throws IOException {
            if (this.queryData == null) {
                throw new IOException("FeatureWriter has been closed");
            }
            FeatureType featureType = this.queryData.getFeatureTypeInfo().getSchema();
            if (this.hasNext()) {
                try {
                    this.queryData.next((QueryDataObserver)this);
                    this.writer.next();
                    this.live = this.fReader.next();
                    this.current = featureType.duplicate(this.live);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + featureType.getTypeName(), (Throwable)e);
                }
            }
            this.live = null;
            if (this.fReader != null) {
                this.fReader.close();
                this.fReader = null;
            }
            try {
                this.current = DataUtilities.template((FeatureType)featureType);
                this.queryData.next((QueryDataObserver)this);
                this.writer.next();
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Unable to add additional Features of " + featureType.getTypeName(), (Throwable)e);
            }
            return this.current;
        }

        public void write() throws IOException {
            if (this.queryData == null) {
                throw new IOException("FeatureWriter has been closed");
            }
            if (this.current == null) {
                throw new IOException("No feature available to write");
            }
            if (this.live != null) {
                if (this.live.equals(this.current)) {
                    this.live = null;
                    this.current = null;
                } else {
                    this.doUpdate(this.live, this.current);
                    Envelope bounds = new Envelope();
                    bounds.expandToInclude(this.live.getBounds());
                    bounds.expandToInclude(this.current.getBounds());
                    MySQLDataStore.this.listenerManager.fireFeaturesChanged(this.queryData.getFeatureTypeInfo().getFeatureTypeName(), this.queryData.getTransaction(), bounds);
                    this.live = null;
                    this.current = null;
                }
            } else {
                try {
                    this.doInsert(this.current);
                }
                catch (SQLException e) {
                    throw new DataSourceException("Row adding failed.", (Throwable)e);
                }
                MySQLDataStore.this.listenerManager.fireFeaturesAdded(this.queryData.getFeatureTypeInfo().getFeatureTypeName(), this.queryData.getTransaction(), this.current.getBounds());
                this.current = null;
            }
        }

        private void doUpdate(Feature live, Feature current) throws IOException {
            try {
                for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
                    Object curAtt = current.getAttribute(i);
                    Object liveAtt = live.getAttribute(i);
                    if (live != null && DataUtilities.attributesEqual((Object)curAtt, (Object)liveAtt)) continue;
                    this.writer.write(i, curAtt);
                }
            }
            catch (IOException ioe) {
                String message = "problem modifying row";
                if (this.queryData.getTransaction() != Transaction.AUTO_COMMIT) {
                    this.queryData.getTransaction().rollback();
                    message = message + "(transaction canceled)";
                }
                throw ioe;
            }
        }

        public void remove() throws IOException {
            if (this.queryData == null) {
                throw new IOException("FeatureWriter has been closed");
            }
            if (this.current == null) {
                throw new IOException("No feature available to remove");
            }
            if (this.live != null) {
                Envelope bounds = this.live.getBounds();
                Statement statement = null;
                try {
                    statement = this.queryData.getConnection().createStatement();
                    String sql = MySQLDataStore.this.makeDeleteSql(this.current, this.queryData.getFeatureTypeInfo());
                    System.out.println("going to delete:");
                    System.out.println(sql);
                    statement.executeUpdate(sql);
                    statement.close();
                    this.live = null;
                    this.current = null;
                    MySQLDataStore.this.listenerManager.fireFeaturesRemoved(this.queryData.getFeatureTypeInfo().getFeatureTypeName(), this.queryData.getTransaction(), bounds);
                }
                catch (SQLException sqle) {
                    String message = "problem deleting row";
                    if (this.queryData.getTransaction() != Transaction.AUTO_COMMIT) {
                        this.queryData.getTransaction().rollback();
                        message = message + "(transaction canceled)";
                    }
                    throw new DataSourceException(message, (Throwable)sqle);
                }
            } else {
                this.current = null;
            }
        }
    }
}

