/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.ConnectionPoolManager;

public class MySQLConnectionFactory {
    private static final String MYSQL_URL_PREFIX = "jdbc:mysql://";
    private static Map _dataSources = new HashMap();
    private String _dbURL;
    private String _username = "";
    private String _password = "";

    public MySQLConnectionFactory(String url) {
        this._dbURL = url;
    }

    public MySQLConnectionFactory(String host, Integer port, String instance) {
        this(MYSQL_URL_PREFIX + host + ":" + port.toString() + "/" + instance);
    }

    public MySQLConnectionFactory(String host, String instance) {
        this(host, new Integer(3306), instance);
    }

    public ConnectionPool getConnectionPool(String username, String password) throws SQLException {
        this.setLogin(username, password);
        return this.getConnectionPool();
    }

    public ConnectionPool getConnectionPool() throws SQLException {
        String poolKey = this._dbURL + this._username + this._password;
        MysqlConnectionPoolDataSource poolDataSource = (MysqlConnectionPoolDataSource)_dataSources.get(poolKey);
        if (poolDataSource == null) {
            poolDataSource = new MysqlConnectionPoolDataSource();
            poolDataSource.setURL(this._dbURL);
            poolDataSource.setUser(this._username);
            poolDataSource.setPassword(this._password);
            _dataSources.put(poolKey, poolDataSource);
        }
        ConnectionPoolManager manager = ConnectionPoolManager.getInstance();
        ConnectionPool connectionPool = manager.getConnectionPool((ConnectionPoolDataSource)poolDataSource);
        return connectionPool;
    }

    public void setLogin(String username, String password) {
        this._username = username;
        this._password = password;
    }
}

