/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mysql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.QueryDataObserver;
import org.geotools.data.jdbc.ResultSetAttributeIO;
import org.geotools.feature.AttributeType;

public class MySQLAttributeWriter
extends ResultSetAttributeIO
implements AttributeWriter {
    public MySQLAttributeWriter(AttributeType[] metaData, QueryData queryData, int startColumn, int endColumn) {
        super(metaData, queryData, startColumn, endColumn);
    }

    public void write(int position, Object attribute) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Close has already been called on this MySQLAttributeWriter.");
        }
        Statement statement = null;
        try {
            Connection conn = this.queryData.getConnection();
            statement = conn.createStatement();
            JDBCDataStore.FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
            StringBuffer sql = new StringBuffer("UPDATE ");
            sql.append(ftInfo.getFeatureTypeName() + " SET ");
            AttributeType type = this.metaData[position];
            String name = type.getName();
            String newValue = null;
            newValue = this.formatValue(attribute);
            sql.append(name + " = " + newValue);
            String fidColName = ftInfo.getFidColumnName();
            QueryData.RowData rd = this.queryData.getRowData((QueryDataObserver)this);
            Object fid = rd.read(1);
            sql.append(" WHERE " + fidColName + " = " + fid);
            System.out.println("this sql statement = " + sql.toString());
            statement.executeUpdate(sql.toString());
        }
        catch (SQLException sqle) {
            try {
                String msg = "SQL Exception writing column";
                this.queryData.close(sqle, (QueryDataObserver)this);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(statement);
                throw throwable;
            }
        }
        JDBCUtils.close((Statement)statement);
    }

    protected String formatValue(Object value) {
        String retString = value != null ? "'" + value.toString() + "'" : "null";
        return retString;
    }
}

