/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.tools;

import java.util.logging.Logger;
import org.geotools.gui.tools.PanTool;
import org.geotools.gui.tools.ToolList;
import org.geotools.gui.tools.ZoomTool;

public abstract class ToolFactory {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gui.tools.ToolFactory");
    private static ToolFactory factory = null;

    public static ToolFactory createFactory() {
        if (factory == null) {
            String factoryClass = System.getProperty("ToolFactoryImpl");
            LOGGER.fine("loaded property = " + factoryClass);
            if (factoryClass != null && factoryClass != "") {
                factory = ToolFactory.createFactory(factoryClass);
            }
            if (factory == null) {
                factory = ToolFactory.createFactory("org.geotools.gui.tools.ToolFactoryImpl");
            }
        }
        return factory;
    }

    public static ToolFactory createFactory(String factoryClass) {
        try {
            factory = (ToolFactory)Class.forName(factoryClass).newInstance();
            return factory;
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("createFactory failed to find implementation " + factoryClass + " , " + e);
        }
        catch (InstantiationException e) {
            LOGGER.warning("createFactory failed to insantiate implementation " + factoryClass + " , " + e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warning("createStyleFactory failed to access implementation " + factoryClass + " , " + e);
        }
        return null;
    }

    public abstract PanTool createPanTool();

    public abstract ZoomTool createZoomTool();

    public abstract ZoomTool createZoomTool(double var1);

    public abstract ToolList createToolList();

    public abstract ToolList createDefaultToolList();
}

