/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.geotools.filter.Expression;

public abstract class DefaultExpression
implements Expression {
    public static final short LITERAL_DOUBLE = 101;
    public static final short LITERAL_INTEGER = 102;
    public static final short LITERAL_STRING = 103;
    public static final short LITERAL_GEOMETRY = 104;
    public static final short MATH_ADD = 105;
    public static final short MATH_SUBTRACT = 106;
    public static final short MATH_MULTIPLY = 107;
    public static final short MATH_DIVIDE = 108;
    public static final short ATTRIBUTE_DOUBLE = 109;
    public static final short ATTRIBUTE_INTEGER = 110;
    public static final short ATTRIBUTE_STRING = 111;
    public static final short ATTRIBUTE_GEOMETRY = 112;
    public static final short ATTRIBUTE_UNDECLARED = 100;
    public static final short ATTRIBUTE = 113;
    public static final short FUNCTION = 114;
    protected short expressionType;
    protected boolean permissiveConstruction;

    public short getType() {
        return this.expressionType;
    }

    public Object getValue(Feature feature) {
        return new Object();
    }

    protected static boolean isAttributeExpression(short expressionType) {
        return expressionType == 109 || expressionType == 110 || expressionType == 111;
    }

    protected static boolean isMathExpression(short expressionType) {
        return expressionType == 105 || expressionType == 106 || expressionType == 107 || expressionType == 108;
    }

    protected static boolean isLiteralExpression(short expressionType) {
        return expressionType == 104 || expressionType == 101 || expressionType == 102 || expressionType == 103;
    }

    protected static boolean isGeometryExpression(short expressionType) {
        return expressionType == 112 || expressionType == 104;
    }

    protected static boolean isExpression(short expressionType) {
        return DefaultExpression.isMathExpression(expressionType) || DefaultExpression.isAttributeExpression(expressionType) || DefaultExpression.isLiteralExpression(expressionType);
    }
}

