/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;

public abstract class AbstractFilter
implements Filter {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    public static final short LOGIC_OR = 1;
    public static final short LOGIC_AND = 2;
    public static final short LOGIC_NOT = 3;
    public static final short GEOMETRY_BBOX = 4;
    public static final short GEOMETRY_EQUALS = 5;
    public static final short GEOMETRY_DISJOINT = 6;
    public static final short GEOMETRY_INTERSECTS = 7;
    public static final short GEOMETRY_TOUCHES = 8;
    public static final short GEOMETRY_CROSSES = 9;
    public static final short GEOMETRY_WITHIN = 10;
    public static final short GEOMETRY_CONTAINS = 11;
    public static final short GEOMETRY_OVERLAPS = 12;
    public static final short GEOMETRY_BEYOND = 13;
    public static final short GEOMETRY_DWITHIN = 24;
    public static final short COMPARE_EQUALS = 14;
    public static final short COMPARE_LESS_THAN = 15;
    public static final short COMPARE_GREATER_THAN = 16;
    public static final short COMPARE_LESS_THAN_EQUAL = 17;
    public static final short COMPARE_GREATER_THAN_EQUAL = 18;
    public static final short COMPARE_NOT_EQUALS = 23;
    public static final short BETWEEN = 19;
    public static final short NULL = 21;
    public static final short LIKE = 20;
    public static final short FID = 22;
    protected short filterType;
    protected boolean permissiveConstruction = true;

    public abstract boolean contains(Feature var1);

    protected static boolean isLogicFilter(short filterType) {
        LOGGER.entering("AbstractFilter", "isLogicFilter", new Short(filterType));
        return filterType == 1 || filterType == 2 || filterType == 3;
    }

    protected static boolean isMathFilter(short filterType) {
        return filterType == 15 || filterType == 16 || filterType == 17 || filterType == 18;
    }

    protected static boolean isCompareFilter(short filterType) {
        return AbstractFilter.isMathFilter(filterType) || filterType == 14 || filterType == 19 || filterType == 23;
    }

    protected static boolean isGeometryFilter(short filterType) {
        return filterType == 4 || filterType == 5 || filterType == 6 || filterType == 8 || filterType == 7 || filterType == 9 || filterType == 10 || filterType == 11 || filterType == 12 || filterType == 24 || filterType == 13;
    }

    protected static boolean isGeometryDistanceFilter(short filterType) {
        return filterType == 24 || filterType == 13;
    }

    protected static boolean isSimpleFilter(short filterType) {
        return AbstractFilter.isCompareFilter(filterType) || AbstractFilter.isGeometryFilter(filterType) || filterType == 21 || filterType == 22 || filterType == 20;
    }

    public short getFilterType() {
        return this.filterType;
    }

    public abstract void accept(FilterVisitor var1);
}

