/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryConfigurationError;

public final class FactoryFinder {
    private FactoryFinder() {
    }

    private static Object newInstance(String clazz, ClassLoader loader) {
        Logger logger = Logger.getLogger("org.geotools.factory");
        logger.finest("Creating instance from '" + clazz + "'");
        try {
            Class<?> spiClass = loader == null ? Class.forName(clazz) : loader.loadClass(clazz);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new FactoryConfigurationError("Provider " + clazz + " not found - " + "please check your classpath", x);
        }
        catch (ExceptionInInitializerError eiie) {
            throw new FactoryConfigurationError("Provider " + clazz + " not initialized - " + "error in constructor", eiie);
        }
        catch (InstantiationException ie) {
            throw new FactoryConfigurationError("Provider " + clazz + " could not be instantiated - " + "is it abstract, an interface, an array, or does it not have an " + "empty constructor?", ie);
        }
        catch (IllegalAccessException iae) {
            throw new FactoryConfigurationError("Provider " + clazz + " could not be accessed - " + "is it private or is the empty constructor private?", iae);
        }
    }

    private static ClassLoader findLoader() {
        Logger logger = Logger.getLogger("org.geotools.factory");
        logger.finest("Finding ClassLoader");
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            logger.finest("Using context ClassLoader " + classLoader);
        }
        catch (SecurityException se) {
            classLoader = FactoryFinder.class.getClassLoader();
            logger.finest("Using system ClassLoader " + classLoader);
        }
        return classLoader;
    }

    private static Factory getFactory(URL resource, ClassLoader loader) throws IOException {
        Logger.getLogger("org.geotools.factory").finest("Searching resource " + resource);
        if (resource == null) {
            return null;
        }
        InputStream in = resource.openStream();
        return FactoryFinder.getFactory(in, loader);
    }

    private static Factory getFactory(InputStream in, ClassLoader loader) throws IOException {
        Logger log = Logger.getLogger("org.geotools.factory");
        log.finest("Reading Factory , has stream : " + (in != null));
        if (in != null) {
            BufferedReader rd = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String factoryClassName = rd.readLine().trim();
            rd.close();
            if (factoryClassName != null && factoryClassName.length() != 0) {
                return (Factory)FactoryFinder.newInstance(factoryClassName, loader);
            }
            log.finest("Factory name unacceptable : '" + factoryClassName + "'");
        }
        return null;
    }

    public static Factory findFactory(String factoryKey, String defaultImpl, ClassLoader classLoader) throws FactoryConfigurationError, ClassCastException {
        Logger logger = Logger.getLogger("org.geotools.factory");
        logger.finest("findFactory(" + factoryKey + "," + defaultImpl + "," + classLoader + ")");
        if (classLoader == null) {
            classLoader = FactoryFinder.findLoader();
        }
        logger.finest("ClassLoader : " + classLoader);
        try {
            logger.finest("Searching system properties");
            String systemProp = System.getProperty(factoryKey);
            if (systemProp != null) {
                logger.finest(factoryKey + "=" + systemProp);
                return (Factory)FactoryFinder.newInstance(systemProp, classLoader);
            }
            logger.finest("Key '" + factoryKey + "' not found");
        }
        catch (SecurityException se) {
            logger.finest("SecurityException " + se.getMessage());
        }
        String serviceId = "META-INF/services/" + factoryKey;
        logger.finest("Searching for service: " + serviceId);
        try {
            InputStream is = classLoader.getResourceAsStream(serviceId);
            Factory f = FactoryFinder.getFactory(is, classLoader);
            if (f != null) {
                return f;
            }
            logger.finest("Service '" + serviceId + "' not found");
        }
        catch (Exception ex) {
            logger.finest("Exception " + ex.getMessage());
        }
        logger.finest("Resorting to default");
        if (defaultImpl == null) {
            logger.finest("No default");
            throw new FactoryConfigurationError("Provider for " + factoryKey + " cannot be found", null);
        }
        return (Factory)FactoryFinder.newInstance(defaultImpl, classLoader);
    }

    public static Factory findFactory(String factoryKey, String defaultImpl) throws FactoryConfigurationError, ClassCastException {
        return FactoryFinder.findFactory(factoryKey, defaultImpl, FactoryFinder.findLoader());
    }

    public static Iterator factories(Class key) {
        return FactoryFinder.factories(key, FactoryFinder.findLoader());
    }

    public static Iterator factories(Class key, final ClassLoader loader) {
        String clazz = key.getName();
        String serviceId = "META-INF/services/" + clazz;
        try {
            final Enumeration<URL> resources = loader.getResources(serviceId);
            return new Iterator(){

                public boolean hasNext() {
                    return resources.hasMoreElements();
                }

                public Object next() {
                    URL url = (URL)resources.nextElement();
                    try {
                        return FactoryFinder.getFactory(url, loader);
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected IOException " + ioe.getMessage(), ioe);
        }
    }
}

