/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.Arrays;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.filter.Filter;
import org.opengis.sc.CoordinateReferenceSystem;

public class DefaultQuery
implements Query {
    private String[] properties;
    private int maxFeatures = 100000000;
    private Filter filter = Filter.NONE;
    private String typeName;
    private String handle;
    private CoordinateReferenceSystem coordinateSystem;
    private CoordinateReferenceSystem coordinateSystemReproject;

    public DefaultQuery() {
    }

    public DefaultQuery(String typeName) {
        this(typeName, Filter.NONE);
    }

    public DefaultQuery(Filter filter) {
        this.filter = filter;
    }

    public DefaultQuery(String typeName, Filter filter) {
        this(filter);
        this.typeName = typeName;
    }

    public DefaultQuery(Filter filter, String[] properties) {
        this(filter);
        this.properties = properties;
    }

    public DefaultQuery(String typeName, Filter filter, int maxFeatures, String[] propNames, String handle) {
        this(typeName, filter);
        this.properties = propNames;
        this.maxFeatures = maxFeatures;
        this.handle = handle;
    }

    public String[] getPropertyNames() {
        return this.properties;
    }

    public void setPropertyNames(String[] propNames) {
        this.properties = propNames;
    }

    public void setPropertyNames(List propNames) {
        if (propNames == null) {
            this.properties = null;
            return;
        }
        String[] stringArr = new String[propNames.size()];
        this.properties = propNames.toArray(stringArr);
    }

    public boolean retrieveAllProperties() {
        return this.properties == null;
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getVersion() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("No feature versioning yet");
    }

    public int hashCode() {
        String[] n = this.getPropertyNames();
        return (n == null ? -1 : (n.length == 0 ? 0 : n.length | n[0].hashCode())) | this.getMaxFeatures() | (this.getFilter() == null ? 0 : this.getFilter().hashCode()) | (this.getTypeName() == null ? 0 : this.getTypeName().hashCode()) | (this.getVersion() == null ? 0 : this.getVersion().hashCode()) | (this.getCoordianteSystem() == null ? 0 : this.getCoordianteSystem().hashCode()) | (this.getCoordianteSystemReproject() == null ? 0 : this.getCoordianteSystemReproject().hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Query)) {
            return false;
        }
        Query other = (Query)obj;
        return Arrays.equals(this.getPropertyNames(), other.getPropertyNames()) && this.retrieveAllProperties() == other.retrieveAllProperties() && this.getMaxFeatures() == other.getMaxFeatures() && (this.getFilter() == null ? other.getFilter() == null : this.getFilter().equals(other.getFilter())) && (this.getTypeName() == null ? other.getTypeName() == null : this.getTypeName().equals(other.getTypeName())) && (this.getVersion() == null ? other.getVersion() == null : this.getVersion().equals(other.getVersion())) && (this.getCoordianteSystem() == null ? other.getCoordianteSystem() == null : this.getCoordianteSystem().equals(other.getCoordianteSystem())) && (this.getCoordianteSystemReproject() == null ? other.getCoordianteSystemReproject() == null : this.getCoordianteSystemReproject().equals(other.getCoordianteSystemReproject()));
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("Query:");
        if (this.handle != null) {
            returnString.append(" [" + this.handle + "]");
        }
        returnString.append("\n   feature type: " + this.typeName);
        if (this.filter != null) {
            returnString.append("\n   filter: " + this.filter.toString());
        }
        returnString.append("\n   [properties: ");
        if (this.properties == null || this.properties.length == 0) {
            return returnString + " ALL ]";
        }
        for (int i = 0; i < this.properties.length; ++i) {
            returnString.append(this.properties[i]);
            if (i >= this.properties.length - 1) continue;
            returnString.append(", ");
        }
        returnString.append("]");
        return returnString.toString();
    }

    public CoordinateReferenceSystem getCoordianteSystem() {
        return this.coordinateSystem;
    }

    public CoordinateReferenceSystem getCoordianteSystemReproject() {
        return this.coordinateSystemReproject;
    }

    public void setCoordianteSystem(CoordinateReferenceSystem system) {
        this.coordinateSystem = system;
    }

    public void setCoordianteSystemReproject(CoordinateReferenceSystem system) {
        this.coordinateSystemReproject = system;
    }
}

