/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gtopo30;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.data.gtopo30.GTopo30DataSource;

public class GTopo30DataSourceFactory
implements DataSourceFactorySpi {
    public boolean canProcess(Map params) {
        boolean accept = false;
        try {
            if (params.containsKey("url")) {
                String url = (String)params.get("url");
                GTopo30DataSource ds = new GTopo30DataSource(new URL(url));
                accept = true;
            }
        }
        catch (Exception e) {
            accept = false;
        }
        return accept;
    }

    public DataSource createDataSource(Map params) throws DataSourceException {
        GTopo30DataSource ds = null;
        if (this.canProcess(params)) {
            String location = (String)params.get("url");
            try {
                ds = new GTopo30DataSource(new URL(location));
            }
            catch (MalformedURLException mue) {
                throw new DataSourceException("Unable to attatch datasource to " + location, (Throwable)mue);
            }
        }
        return ds;
    }

    public String getDescription() {
        return "GTOPO30 global 30' DEM (*.dem)";
    }
}

