/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gtopo30;

import com.sun.media.imageio.stream.FileChannelImageInputStream;
import com.sun.media.imageio.stream.RawImageInputStream;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.CoordinateSystemFactory;
import org.geotools.cs.FactoryException;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cs.PrimeMeridian;
import org.geotools.cv.Category;
import org.geotools.cv.SampleDimension;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.Query;
import org.geotools.data.gtopo30.GT30Header;
import org.geotools.data.gtopo30.GT30Stats;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.gc.GridCoverage;
import org.geotools.gc.GridGeometry;
import org.geotools.gc.GridRange;
import org.geotools.pt.Envelope;
import org.geotools.units.Unit;

public class GTopo30DataSource
extends AbstractDataSource {
    private static final int TILE_SIZE = 131072;
    private URL demURL;
    private URL demHeaderURL;
    private URL srcURL;
    private URL srcHeaderURL;
    private URL statsURL;
    private String name = null;
    private com.vividsolutions.jts.geom.Envelope cropEnvelope;
    private Color[] demColors = new Color[]{new Color(5, 90, 5), new Color(150, 200, 150), new Color(190, 150, 20), new Color(100, 100, 50), new Color(200, 210, 220), Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE};
    private String filename;

    public GTopo30DataSource(URL url) throws MalformedURLException, DataSourceException {
        try {
            this.filename = URLDecoder.decode(url.getFile(), "US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + url + " cause " + use.getMessage());
        }
        boolean recognized = false;
        String dmext = ".dem";
        String dhext = ".hdr";
        String srext = ".src";
        String shext = ".sch";
        String stext = ".stx";
        if (this.filename.endsWith(dmext) || this.filename.endsWith(dhext) || this.filename.endsWith(srext) || this.filename.endsWith(shext) || this.filename.endsWith(stext)) {
            recognized = true;
        } else {
            dmext = dmext.toUpperCase();
            dhext = dhext.toUpperCase();
            srext = srext.toUpperCase();
            shext = shext.toUpperCase();
            stext = stext.toUpperCase();
            if (this.filename.endsWith(dmext) || this.filename.endsWith(dhext) || this.filename.endsWith(srext) || this.filename.endsWith(shext) || this.filename.endsWith(stext)) {
                recognized = true;
            }
        }
        if (!recognized) {
            throw new DataSourceException("Unrecognized file (file extension doesn't match)");
        }
        this.name = this.filename.substring(0, this.filename.length() - 4);
        this.demURL = new URL(url, this.name + dmext);
        this.demHeaderURL = new URL(url, this.name + dhext);
        this.srcURL = new URL(url, this.name + srext);
        this.srcHeaderURL = new URL(url, this.name + shext);
        this.statsURL = new URL(url, this.name + stext);
    }

    public com.vividsolutions.jts.geom.Envelope getBounds() {
        com.vividsolutions.jts.geom.Envelope env = null;
        try {
            GT30Header header = new GT30Header(this.demHeaderURL);
            double xmin = header.getULXMap() - header.getXDim() / 2.0;
            double ymax = header.getULYMap() + header.getYDim() / 2.0;
            double ymin = ymax - (double)header.getNRows() * header.getYDim();
            double xmax = xmin + (double)header.getNCols() * header.getXDim();
            env = new com.vividsolutions.jts.geom.Envelope(xmin, xmax, ymin, ymax);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error!" + e);
        }
        return env;
    }

    public void setCropEnvelope(com.vividsolutions.jts.geom.Envelope crop) {
        com.vividsolutions.jts.geom.Envelope bbox = this.getBounds();
        if (bbox.intersects(crop)) {
            this.cropEnvelope = crop;
        }
    }

    public com.vividsolutions.jts.geom.Envelope getCropEnvelope() {
        return this.cropEnvelope;
    }

    public FeatureCollection getFeatures(Filter filter) throws DataSourceException {
        FeatureCollection fc = FeatureCollections.newCollection();
        this.getFeatures(fc, filter);
        return fc;
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        GT30Header header = null;
        try {
            header = new GT30Header(this.demHeaderURL);
        }
        catch (Exception e) {
            throw new DataSourceException("Unexpected exception", (Throwable)e);
        }
        int nrows = header.getNRows();
        int ncols = header.getNCols();
        double xdim = header.getXDim();
        double ydim = header.getYDim();
        double minx = header.getULXMap() - xdim / 2.0;
        double miny = header.getULYMap() + ydim / 2.0 - ydim * (double)nrows;
        GT30Stats stats = null;
        try {
            stats = new GT30Stats(this.statsURL);
        }
        catch (Exception e) {
            throw new DataSourceException("Unexpected exception", (Throwable)e);
        }
        int max = stats.getMax();
        FileChannelImageInputStream iis = null;
        try {
            String filePath = URLDecoder.decode(this.demURL.getFile(), "US-ASCII");
            FileInputStream fis = new FileInputStream(filePath);
            FileChannel channel = fis.getChannel();
            iis = new FileChannelImageInputStream(channel);
        }
        catch (Exception e) {
            throw new DataSourceException("Unexpected exception", (Throwable)e);
        }
        ColorSpace graycs = ICC_ColorSpace.getInstance(1003);
        ComponentColorModel cm = new ComponentColorModel(graycs, false, false, 3, 2);
        BandedSampleModel sm = new BandedSampleModel(2, ncols, nrows, 1);
        ImageTypeSpecifier its = new ImageTypeSpecifier(cm, sm);
        RawImageInputStream raw = new RawImageInputStream((ImageInputStream)iis, its, new long[]{0L}, new Dimension[]{new Dimension(ncols, nrows)});
        com.vividsolutions.jts.geom.Envelope env = this.getBounds();
        Object irp = null;
        int tileRows = (int)Math.ceil(131072 / (ncols * 2));
        ImageLayout il = new ImageLayout(0, 0, ncols, nrows, 0, 0, ncols, tileRows, (SampleModel)sm, (ColorModel)cm);
        ParameterBlockJAI pbj = new ParameterBlockJAI("ImageRead");
        pbj.setParameter("Input", (Object)raw);
        pbj.setParameter("ReadParam", irp);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il);
        hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, null));
        RenderedOp image = JAI.create((String)"ImageRead", (ParameterBlock)pbj, (RenderingHints)hints);
        if (this.cropEnvelope != null) {
            env = this.intersectEnvelope(env, this.cropEnvelope);
            float cxmin = Math.round((env.getMinX() - minx) / xdim);
            float cymin = Math.round((env.getMinY() - miny) / ydim);
            float cwidth = Math.round(env.getWidth() / xdim);
            float cheight = Math.round(env.getHeight() / ydim);
            cymin = (float)nrows - cymin - cheight;
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(cxmin);
            pb.add(cymin);
            pb.add(cwidth);
            pb.add(cheight);
            hints = new RenderingHints(JAI.KEY_TILE_CACHE, null);
            image = JAI.create((String)"Crop", (ParameterBlock)pb, (RenderingHints)hints);
            pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(-cxmin);
            pb.add(-cymin);
            image = JAI.create((String)"Translate", (ParameterBlock)pb, (RenderingHints)hints);
        }
        CoordinateSystemFactory csFactory = CoordinateSystemFactory.getDefault();
        HorizontalDatum datum = HorizontalDatum.WGS84;
        PrimeMeridian meridian = PrimeMeridian.GREENWICH;
        GeographicCoordinateSystem sourceCS = null;
        try {
            sourceCS = csFactory.createGeographicCoordinateSystem((CharSequence)"Geographic - WGS84", Unit.DEGREE, datum, meridian, AxisInfo.LATITUDE, AxisInfo.LONGITUDE);
        }
        catch (FactoryException fe) {
            throw new DataSourceException("Unexpected error", (Throwable)fe);
        }
        double offset = 0.0;
        double scale = (double)max / 256.0;
        Category nullValue = new Category("null", null, 0, 1, 1.0, (double)header.getNoData());
        Category elevation = new Category("elevation", this.demColors, 1, 256, scale, offset);
        SampleDimension sd = new SampleDimension(new Category[]{nullValue, elevation}, Unit.METRE);
        SampleDimension geoSd = sd.geophysics(true);
        SampleDimension[] bands = new SampleDimension[]{geoSd};
        GridRange gr = new GridRange((RenderedImage)image);
        GridGeometry gg = new GridGeometry(gr, this.convertEnvelope(env), new boolean[]{false, true});
        GridCoverage gc = new GridCoverage("topo", (RenderedImage)image, (CoordinateSystem)sourceCS, gg.getGridToCoordinateSystem(), bands, null, null);
        try {
            collection.add((Object)this.wrapGcInFeature(gc));
        }
        catch (Exception e) {
            throw new DataSourceException("Unexpected error", (Throwable)e);
        }
    }

    private Feature wrapGcInFeature(GridCoverage gc) {
        PrecisionModel pm = new PrecisionModel();
        Rectangle2D rect = gc.getEnvelope().toRectangle2D();
        Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())};
        Feature feature = null;
        try {
            LinearRing ring = new LinearRing(coord, pm, 0);
            Polygon bounds = new Polygon(ring, pm, 0);
            AttributeType geom = AttributeTypeFactory.newAttributeType((String)"geom", (Class)Polygon.class);
            AttributeType grid = AttributeTypeFactory.newAttributeType((String)"grid", (Class)GridCoverage.class);
            FeatureType schema = null;
            AttributeType[] attTypes = new AttributeType[]{geom, grid};
            schema = FeatureTypeFactory.newFeatureType((AttributeType[])attTypes, (String)this.filename);
            feature = schema.create(new Object[]{bounds, gc});
        }
        catch (SchemaException e) {
            throw new RuntimeException("A schema exception occurred, that should not happen!", e);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException("An illegal attribute exception occurred, that should not happen!", e);
        }
        return feature;
    }

    private Envelope convertEnvelope(com.vividsolutions.jts.geom.Envelope source) {
        double[] min = new double[]{source.getMinX(), source.getMinY()};
        double[] max = new double[]{source.getMaxX(), source.getMaxY()};
        return new Envelope(min, max);
    }

    private com.vividsolutions.jts.geom.Envelope intersectEnvelope(com.vividsolutions.jts.geom.Envelope a, com.vividsolutions.jts.geom.Envelope b) {
        com.vividsolutions.jts.geom.Envelope env = null;
        if (a.intersects(b)) {
            env = new com.vividsolutions.jts.geom.Envelope(Math.max(a.getMinX(), b.getMinX()), Math.min(a.getMaxX(), b.getMaxX()), Math.max(a.getMinY(), b.getMinY()), Math.min(a.getMaxY(), b.getMaxY()));
        }
        return env;
    }

    public FeatureType getSchema() {
        try {
            AttributeType geom = AttributeTypeFactory.newAttributeType((String)"geom", (Class)Polygon.class);
            AttributeType grid = AttributeTypeFactory.newAttributeType((String)"grid", (Class)GridCoverage.class);
            Object schema = null;
            AttributeType[] attTypes = new AttributeType[]{geom, grid};
            return FeatureTypeFactory.newFeatureType((AttributeType[])attTypes, (String)this.name);
        }
        catch (SchemaException e) {
            throw new RuntimeException("Hey, someone broke the GTopo30DataSource.getSchema() code!");
        }
    }

    public Color[] getColors() {
        return this.demColors;
    }

    public void setColors(Color[] colors) {
        if (colors != null) {
            this.demColors = colors;
        }
    }
}

