/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;

public class XMLEncoder
implements FilterVisitor {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter");
    private static Map comparisions = new HashMap();
    private static Map spatial = new HashMap();
    private static Map logical = new HashMap();
    private static Map expressions = new HashMap();
    private Writer out;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Point;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$LineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Polygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPoint;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiLineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPolygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$GeometryCollection;

    public XMLEncoder(Writer out) {
        this.out = out;
    }

    public XMLEncoder(Writer out, Filter filter) {
        this.out = out;
        try {
            this.encode(filter);
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void encode(Filter filter) throws IOException {
        this.out.write("<Filter>\n");
        filter.accept((FilterVisitor)this);
        this.out.write("</Filter>\n");
    }

    public void encode(Expression expression) {
        expression.accept((FilterVisitor)this);
    }

    public void visit(Filter filter) {
        LOGGER.warning("exporting unknown filter type");
    }

    public void visit(BetweenFilter filter) {
        LOGGER.finer("exporting BetweenFilter");
        Expression left = filter.getLeftValue();
        Expression right = filter.getRightValue();
        Expression mid = filter.getMiddleValue();
        LOGGER.finer("Filter type id is " + filter.getFilterType());
        LOGGER.finer("Filter type text is " + comparisions.get(new Integer(filter.getFilterType())));
        String type = (String)comparisions.get(new Integer(filter.getFilterType()));
        try {
            this.out.write("<" + type + ">\n");
            mid.accept((FilterVisitor)this);
            this.out.write("<LowerBoundary>\n");
            left.accept((FilterVisitor)this);
            this.out.write("</LowerBoundary>\n<UpperBoundary>\n");
            right.accept((FilterVisitor)this);
            this.out.write("</UpperBoundary>\n");
            this.out.write("</" + type + ">\n");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void visit(LikeFilter filter) {
        LOGGER.finer("exporting like filter");
        try {
            String wcm = filter.getWildcardMulti();
            String wcs = filter.getWildcardSingle();
            String esc = filter.getEscape();
            this.out.write("<PropertyIsLike wildCard=\"" + wcm + "\" singleChar=\"" + wcs + "\" escape=\"" + esc + "\">\n");
            filter.getValue().accept((FilterVisitor)this);
            this.out.write("<Literal>" + filter.getPattern() + "</Literal>\n");
            this.out.write("</PropertyIsLike>\n");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void visit(LogicFilter filter) {
        LOGGER.finer("exporting LogicFilter");
        filter.getFilterType();
        String type = (String)logical.get(new Integer(filter.getFilterType()));
        try {
            this.out.write("<" + type + ">\n");
            Iterator list = filter.getFilterIterator();
            while (list.hasNext()) {
                ((AbstractFilter)list.next()).accept((FilterVisitor)this);
            }
            this.out.write("</" + type + ">\n");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void visit(CompareFilter filter) {
        LOGGER.finer("exporting ComparisonFilter");
        Expression left = filter.getLeftValue();
        Expression right = filter.getRightValue();
        LOGGER.finer("Filter type id is " + filter.getFilterType());
        LOGGER.finer("Filter type text is " + comparisions.get(new Integer(filter.getFilterType())));
        String type = (String)comparisions.get(new Integer(filter.getFilterType()));
        try {
            this.out.write("<" + type + ">\n");
            LOGGER.fine("exporting left expression " + left);
            left.accept((FilterVisitor)this);
            LOGGER.fine("exporting right expression " + right);
            right.accept((FilterVisitor)this);
            this.out.write("</" + type + ">\n");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void visit(GeometryFilter filter) {
        LOGGER.finer("exporting GeometryFilter");
        Expression left = filter.getLeftGeometry();
        Expression right = filter.getRightGeometry();
        String type = (String)spatial.get(new Integer(filter.getFilterType()));
        try {
            this.out.write("<" + type + ">\n");
            left.accept((FilterVisitor)this);
            right.accept((FilterVisitor)this);
            this.out.write("</" + type + ">\n");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void visit(NullFilter filter) {
        LOGGER.finer("exporting NullFilter");
        Expression expr = filter.getNullCheckValue();
        String type = (String)comparisions.get(new Integer(filter.getFilterType()));
        try {
            this.out.write("<" + type + ">\n");
            expr.accept((FilterVisitor)this);
            this.out.write("</" + type + ">\n");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export filter" + ioe);
        }
    }

    public void visit(FidFilter filter) {
        LOGGER.finer("exporting FidFilter");
        String[] fids = filter.getFids();
        for (int i = 0; i < fids.length; ++i) {
            try {
                this.out.write("<FeatureId fid=\"" + fids[i] + "\"/>");
                continue;
            }
            catch (IOException ioe) {
                LOGGER.warning("Unable to export filter" + ioe);
            }
        }
    }

    public void visit(AttributeExpression expression) {
        LOGGER.finer("exporting ExpressionAttribute");
        try {
            this.out.write("<PropertyName>" + expression.getAttributePath() + "</PropertyName>\n");
        }
        catch (IOException ioe) {
            LOGGER.finer("Unable to export expresion: " + ioe);
        }
    }

    public void visit(Expression expression) {
        LOGGER.warning("exporting unknown (default) expression");
    }

    public void visit(LiteralExpression expression) {
        LOGGER.finer("exporting LiteralExpression");
        try {
            Object value = expression.getLiteral();
            if (Geometry.class.isAssignableFrom(value.getClass())) {
                GeometryEncoder encoder = new GeometryEncoder(this.out);
                encoder.encode((Geometry)value);
            } else {
                this.out.write("<Literal>" + value + "</Literal>\n");
            }
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export expresion" + ioe);
        }
    }

    public void visit(MathExpression expression) {
        LOGGER.finer("exporting Expression Math");
        String type = (String)expressions.get(new Integer(expression.getType()));
        try {
            this.out.write("<" + type + ">\n");
            expression.getLeftValue().accept((FilterVisitor)this);
            expression.getRightValue().accept((FilterVisitor)this);
            this.out.write("</" + type + ">\n");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export expresion: " + ioe);
        }
    }

    public void visit(FunctionExpression expression) {
        LOGGER.finer("exporting Expression Math");
        String type = (String)expressions.get(new Integer(expression.getType()));
        try {
            this.out.write("<" + type + " name = " + expression.getName() + ">\n");
            Expression[] args = expression.getArgs();
            for (int i = 0; i < args.length; ++i) {
                args[i].accept((FilterVisitor)this);
            }
            this.out.write("</" + type + ">\n");
        }
        catch (IOException ioe) {
            LOGGER.warning("Unable to export expresion: " + ioe);
        }
    }

    static {
        comparisions.put(new Integer(14), "PropertyIsEqualTo");
        comparisions.put(new Integer(16), "PropertyIsGreaterThan");
        comparisions.put(new Integer(18), "PropertyIsGreaterThanOrEqualTo");
        comparisions.put(new Integer(15), "PropertyIsLessThan");
        comparisions.put(new Integer(17), "PropertyIsLessThanOrEqualTo");
        comparisions.put(new Integer(20), "PropertyIsLike");
        comparisions.put(new Integer(21), "PropertyIsNull");
        comparisions.put(new Integer(19), "PropertyIsBetween");
        expressions.put(new Integer(105), "Add");
        expressions.put(new Integer(108), "Div");
        expressions.put(new Integer(107), "Mul");
        expressions.put(new Integer(106), "Sub");
        expressions.put(new Integer(114), "Function");
        spatial.put(new Integer(5), "Equals");
        spatial.put(new Integer(6), "Disjoint");
        spatial.put(new Integer(7), "Intersects");
        spatial.put(new Integer(8), "Touches");
        spatial.put(new Integer(9), "Crosses");
        spatial.put(new Integer(10), "Within");
        spatial.put(new Integer(11), "Contains");
        spatial.put(new Integer(12), "Overlaps");
        spatial.put(new Integer(13), "Beyond");
        spatial.put(new Integer(4), "BBOX");
        logical.put(new Integer(2), "And");
        logical.put(new Integer(1), "Or");
        logical.put(new Integer(3), "Not");
    }

    static class GeometryEncoder {
        private String srs = "epsg:4326";
        private PrintWriter out;

        public GeometryEncoder(Writer out) {
            this.out = new PrintWriter(out);
        }

        public GeometryEncoder(String srs, Writer out) {
            this.out = new PrintWriter(out);
            this.srs = srs;
        }

        public void encode(Geometry geom) {
            Class<?> geomType;
            if ((class$com$vividsolutions$jts$geom$Point == null ? (class$com$vividsolutions$jts$geom$Point = XMLEncoder.class$("com.vividsolutions.jts.geom.Point")) : class$com$vividsolutions$jts$geom$Point).isAssignableFrom(geomType = geom.getClass())) {
                this.encode((Point)geom);
            } else if ((class$com$vividsolutions$jts$geom$LineString == null ? (class$com$vividsolutions$jts$geom$LineString = XMLEncoder.class$("com.vividsolutions.jts.geom.LineString")) : class$com$vividsolutions$jts$geom$LineString).isAssignableFrom(geomType)) {
                this.encode((LineString)geom);
            } else if ((class$com$vividsolutions$jts$geom$Polygon == null ? (class$com$vividsolutions$jts$geom$Polygon = XMLEncoder.class$("com.vividsolutions.jts.geom.Polygon")) : class$com$vividsolutions$jts$geom$Polygon).isAssignableFrom(geomType)) {
                this.encode((Polygon)geom);
            } else if ((class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = XMLEncoder.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint).isAssignableFrom(geomType)) {
                this.encode((MultiPoint)geom);
            } else if ((class$com$vividsolutions$jts$geom$MultiLineString == null ? (class$com$vividsolutions$jts$geom$MultiLineString = XMLEncoder.class$("com.vividsolutions.jts.geom.MultiLineString")) : class$com$vividsolutions$jts$geom$MultiLineString).isAssignableFrom(geomType)) {
                this.encode((MultiLineString)geom);
            } else if ((class$com$vividsolutions$jts$geom$MultiPolygon == null ? (class$com$vividsolutions$jts$geom$MultiPolygon = XMLEncoder.class$("com.vividsolutions.jts.geom.MultiPolygon")) : class$com$vividsolutions$jts$geom$MultiPolygon).isAssignableFrom(geomType)) {
                this.encode((MultiPolygon)geom);
            } else if ((class$com$vividsolutions$jts$geom$GeometryCollection == null ? (class$com$vividsolutions$jts$geom$GeometryCollection = XMLEncoder.class$("com.vividsolutions.jts.geom.GeometryCollection")) : class$com$vividsolutions$jts$geom$GeometryCollection).isAssignableFrom(geomType)) {
                this.encode((GeometryCollection)geom);
            }
        }

        public void encode(Coordinate[] coords) {
            this.out.print("<gml:coordinates>");
            for (int i = 0; i < coords.length; ++i) {
                this.out.print(coords[i].x + "," + coords[i].y);
                this.out.print(i < coords.length - 1 ? " " : "");
            }
            this.out.println("</gml:coordinates>");
        }

        public void encode(Point point) {
            this.out.println("<gml:Point srsName=\"" + this.srs + "\">");
            this.encode(point.getCoordinates());
            this.out.println("</gml:Point>");
        }

        public void encode(LineString line) {
            this.out.println("<gml:LineString srsName=\"" + this.srs + "\">");
            this.encode(line.getCoordinates());
            this.out.println("</gml:LineString>");
        }

        public void encode(Polygon polygon) {
            this.out.println("<gml:Polygon srsName=\"" + this.srs + "\">");
            this.out.println("<gml:outerBoundaryIs>");
            this.encode(polygon.getExteriorRing());
            this.out.println("</gml:outerBoundaryIs>");
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                this.out.println("<gml:innerBoundaryIs>");
                this.encode(polygon.getInteriorRingN(i));
                this.out.println("</gml:innerBoundaryIs>");
            }
            this.out.println("</gml:Polygon>");
        }

        public void encode(MultiPoint mpoint) {
            this.out.println("<gml:MultiPoint srsName=\"" + this.srs + "\">\n");
            for (int i = 0; i < mpoint.getNumGeometries(); ++i) {
                this.encode((Point)mpoint.getGeometryN(i));
            }
            this.out.println("</gml:MultiPoint>\n");
        }

        public void encode(MultiLineString mline) {
            this.out.println("<gml:MultiLineString srsName=\"" + this.srs + "\">\n");
            for (int i = 0; i < mline.getNumGeometries(); ++i) {
                this.encode((LineString)mline.getGeometryN(i));
            }
            this.out.println("</gml:MultiLineString>\n");
        }

        public void encode(MultiPolygon mpolygon) {
            this.out.println("<gml:MultiPolygon srsName=\"" + this.srs + "\">\n");
            for (int i = 0; i < mpolygon.getNumGeometries(); ++i) {
                this.encode((Polygon)mpolygon.getGeometryN(i));
            }
            this.out.println("</gml:MultiPolygon>\n");
        }

        public void encode(GeometryCollection geomcoll) {
            this.out.println("<gml:MultiGeometry srsName=\"" + this.srs + "\">\n");
            for (int i = 0; i < geomcoll.getNumGeometries(); ++i) {
                this.encode(geomcoll.getGeometryN(i));
            }
            this.out.println("</gml:MultiGeometry>\n");
        }
    }
}

