/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.MathExpression;

public class ExpressionSAXParser {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter");
    private static final FilterFactory FILTER_FACT = FilterFactory.createFilterFactory();
    private ExpressionSAXParser expFactory = null;
    private Expression curExprssn = null;
    private String currentState = null;
    private String declaredType = null;
    private boolean readyFlag = false;
    private FeatureType schema;
    private boolean readChars = false;

    public ExpressionSAXParser(FeatureType schema) {
        this.schema = schema;
    }

    public void start(String declaredType) throws IllegalFilterException {
        LOGGER.finer("incoming type: " + declaredType);
        LOGGER.finer("declared type: " + this.declaredType);
        LOGGER.finer("current state: " + this.currentState);
        if (this.expFactory == null) {
            this.declaredType = declaredType;
            if (DefaultExpression.isMathExpression((short)ExpressionSAXParser.convertType(declaredType))) {
                this.expFactory = new ExpressionSAXParser(this.schema);
                this.curExprssn = FILTER_FACT.createMathExpression(ExpressionSAXParser.convertType(declaredType));
                LOGGER.finer("is math expression");
            } else if (DefaultExpression.isLiteralExpression((short)ExpressionSAXParser.convertType(declaredType))) {
                this.curExprssn = FILTER_FACT.createLiteralExpression();
                this.readChars = true;
                LOGGER.finer("is literal expression");
            } else if (DefaultExpression.isAttributeExpression((short)ExpressionSAXParser.convertType(declaredType))) {
                this.curExprssn = FILTER_FACT.createAttributeExpression(this.schema);
                this.readChars = true;
                LOGGER.finer("is attribute expression");
            }
            this.currentState = ExpressionSAXParser.setInitialState(this.curExprssn);
            this.readyFlag = false;
        } else {
            this.expFactory.start(declaredType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void end(String message) throws IllegalFilterException {
        LOGGER.finer("declared type: " + this.declaredType);
        LOGGER.finer("end message: " + message);
        LOGGER.finer("current state: " + this.currentState);
        LOGGER.finest("expression factory: " + this.expFactory);
        if (this.expFactory != null) {
            this.expFactory.end(message);
            if (!this.expFactory.isReady()) return;
            if (this.currentState.equals("leftValue")) {
                ((MathExpression)this.curExprssn).addLeftValue(this.expFactory.create());
                this.currentState = "rightValue";
                this.expFactory = new ExpressionSAXParser(this.schema);
                LOGGER.finer("just added left value: " + this.currentState);
                return;
            } else {
                if (!this.currentState.equals("rightValue")) throw new IllegalFilterException("Attempted to add sub expression in a bad state: " + this.currentState);
                ((MathExpression)this.curExprssn).addRightValue(this.expFactory.create());
                this.currentState = "complete";
                this.expFactory = null;
                LOGGER.finer("just added right value: " + this.currentState);
            }
            return;
        } else {
            if (!this.declaredType.equals(message) || !this.currentState.equals("complete")) throw new IllegalFilterException("Reached end of unready, non-nested expression: " + this.currentState);
            this.readChars = false;
            this.readyFlag = true;
        }
    }

    public boolean isReady() {
        return this.readyFlag;
    }

    public void message(String message) throws IllegalFilterException {
        LOGGER.finer("incoming message: " + message);
        LOGGER.finer("should read chars: " + this.readChars);
        if (this.readChars) {
            if (this.curExprssn instanceof AttributeExpression) {
                LOGGER.finer("...");
                String[] splitName = message.split("[.:/]");
                String newAttName = message;
                newAttName = splitName.length == 1 ? splitName[0] : splitName[splitName.length - 1];
                LOGGER.finer("setting attribute expression: " + newAttName);
                ((AttributeExpression)this.curExprssn).setAttributePath(newAttName);
                LOGGER.finer("...");
                this.currentState = "complete";
                LOGGER.finer("...");
            } else if (this.curExprssn instanceof LiteralExpression) {
                try {
                    Integer temp = new Integer(message);
                    ((LiteralExpression)this.curExprssn).setLiteral((Object)temp);
                    this.currentState = "complete";
                }
                catch (NumberFormatException nfe1) {
                    try {
                        Double temp = new Double(message);
                        ((LiteralExpression)this.curExprssn).setLiteral((Object)temp);
                        this.currentState = "complete";
                    }
                    catch (NumberFormatException nfe2) {
                        String temp = message;
                        ((LiteralExpression)this.curExprssn).setLiteral((Object)temp);
                        this.currentState = "complete";
                    }
                }
            } else if (this.expFactory != null) {
                this.expFactory.message(message);
            }
        } else if (this.expFactory != null) {
            this.expFactory.message(message);
        }
    }

    public void geometry(Geometry geometry) throws IllegalFilterException {
        LOGGER.finer("got geometry: " + geometry.toString());
        this.curExprssn = FILTER_FACT.createLiteralExpression();
        ((LiteralExpression)this.curExprssn).setLiteral((Object)geometry);
        LOGGER.finer("set expression: " + this.curExprssn.toString());
        this.currentState = "complete";
        LOGGER.finer("set current state: " + this.currentState);
    }

    public Expression create() {
        LOGGER.finer("about to create expression: " + this.curExprssn.toString());
        return this.curExprssn;
    }

    private static String setInitialState(Expression expression) throws IllegalFilterException {
        if (expression instanceof MathExpression) {
            return "leftValue";
        }
        if (expression instanceof AttributeExpression || expression instanceof LiteralExpression) {
            return "";
        }
        throw new IllegalFilterException("Created illegal expression: " + expression.getClass().toString());
    }

    protected static short convertType(String expType) {
        if (expType.equals("Add")) {
            return 105;
        }
        if (expType.equals("Sub")) {
            return 106;
        }
        if (expType.equals("Mul")) {
            return 107;
        }
        if (expType.equals("Div")) {
            return 108;
        }
        if (expType.equals("PropertyName")) {
            return 109;
        }
        if (expType.equals("Literal")) {
            return 101;
        }
        return 100;
    }
}

