/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.EmptyStackException;
import java.util.Stack;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterTransformer;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.filter.parser.ExpressionException;
import org.geotools.filter.parser.ExpressionParser;
import org.geotools.filter.parser.ExpressionParserTreeConstants;
import org.geotools.filter.parser.Node;
import org.geotools.filter.parser.ParseException;
import org.geotools.filter.parser.Token;
import org.geotools.filter.parser.TokenMgrError;

public class ExpressionBuilder {
    static /* synthetic */ Class class$org$geotools$filter$AbstractFilter;

    public static Object parse(String input) throws ParseException {
        ExpressionCompiler c = new ExpressionCompiler(input);
        try {
            c.CompilationUnit();
        }
        catch (TokenMgrError tme) {
            throw new ExpressionException(tme.getMessage(), c.getToken(0));
        }
        if (c.exception != null) {
            throw c.exception;
        }
        StackItem item = (StackItem)c.stack.peek();
        return item.built;
    }

    public static String getFormattedErrorMessage(ParseException pe, String input) {
        StringBuffer sb = new StringBuffer(input);
        sb.append('\n');
        Token t = pe.currentToken;
        while (t.next != null) {
            t = t.next;
        }
        int column = t.beginColumn - 1;
        for (int i = 0; i < column; ++i) {
            sb.append(' ');
        }
        sb.append('^').append('\n');
        sb.append(pe.getMessage());
        return sb.toString();
    }

    public static final void main(String[] args) throws Exception {
        System.out.println("Expression Tester");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        FilterTransformer t = new FilterTransformer();
        t.setIndentation(4);
        while (true) {
            System.out.print("> ");
            String line = r.readLine();
            if (line.equals("quit")) break;
            try {
                Object b = ExpressionBuilder.parse(line);
                t.transform(b, System.out);
                System.out.println();
            }
            catch (ParseException pe) {
                System.out.println(ExpressionBuilder.getFormattedErrorMessage(pe, line));
            }
        }
    }

    static class StackItem {
        Object built;
        Token token;

        StackItem(Object b, Token t) {
            this.built = b;
            this.token = t;
        }
    }

    static class ExpressionCompiler
    extends ExpressionParser
    implements ExpressionParserTreeConstants {
        Stack stack = new Stack();
        FilterFactory factory = FilterFactory.createFilterFactory();
        ExpressionException exception = null;
        String input;
        WKTReader reader;

        ExpressionCompiler(String input) {
            super(new StringReader(input));
            this.input = input;
        }

        StackItem popStack() {
            return (StackItem)this.stack.pop();
        }

        Expression expression() throws ExpressionException {
            StackItem item = null;
            try {
                item = this.popStack();
                return (Expression)item.built;
            }
            catch (ClassCastException cce) {
                throw new ExpressionException("Expecting Expression, but found Filter", item.token);
            }
            catch (EmptyStackException ese) {
                throw new ExpressionException("No items on stack", this.getToken(0));
            }
        }

        Filter filter() throws ExpressionException {
            StackItem item = null;
            try {
                item = this.popStack();
                return (Filter)item.built;
            }
            catch (ClassCastException cce) {
                throw new ExpressionException("Expecting Filter, but found Expression", item.token);
            }
            catch (EmptyStackException ese) {
                throw new ExpressionException("No items on stack", this.getToken(0));
            }
        }

        double doubleValue() throws ExpressionException {
            try {
                return ((Number)this.expression().getValue(null)).doubleValue();
            }
            catch (ClassCastException cce) {
                throw new ExpressionException("Expected double", this.getToken(0));
            }
        }

        int intValue() throws ExpressionException {
            try {
                return ((Number)this.expression().getValue(null)).intValue();
            }
            catch (ClassCastException cce) {
                throw new ExpressionException("Expected int", this.getToken(0));
            }
        }

        String stringValue() throws ExpressionException {
            return this.expression().getValue(null).toString();
        }

        public void jjtreeOpenNodeScope(Node n) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jjtreeCloseNodeScope(Node n) throws ParseException {
            try {
                Object built = this.buildObject(n);
                if (built == null) {
                    throw new RuntimeException("INTERNAL ERROR : Node " + n + " resulted in null build");
                }
                this.stack.push(new StackItem(built, this.getToken(0)));
            }
            finally {
                n.dispose();
            }
        }

        String token() {
            return this.getToken((int)0).image;
        }

        MathExpression mathExpression(short type) throws ExpressionException {
            try {
                MathExpression e = this.factory.createMathExpression(type);
                Expression right = this.expression();
                Expression left = this.expression();
                e.addLeftValue(left);
                e.addRightValue(right);
                return e;
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building MathExpression", this.getToken(0), ife);
            }
        }

        LogicFilter logicFilter(short type) throws ExpressionException {
            try {
                Filter right = this.filter();
                Filter left = this.filter();
                return this.factory.createLogicFilter(left, right, type);
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building LogicFilter", this.getToken(0), ife);
            }
        }

        CompareFilter compareFilter(short type) throws ExpressionException {
            try {
                CompareFilter f = this.factory.createCompareFilter(type);
                Expression right = this.expression();
                Expression left = this.expression();
                f.addLeftValue(left);
                f.addRightValue(right);
                return f;
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building CompareFilter", this.getToken(0), ife);
            }
        }

        Object buildObject(Node n) throws ExpressionException {
            switch (n.getType()) {
                case 15: {
                    return this.factory.createLiteralExpression(Integer.parseInt(this.token()));
                }
                case 16: {
                    return this.factory.createLiteralExpression(Double.parseDouble(this.token()));
                }
                case 19: {
                    return this.factory.createLiteralExpression(n.getToken().image);
                }
                case 14: {
                    try {
                        return this.factory.createAttributeExpression(null, this.token());
                    }
                    catch (IllegalFilterException ife) {
                        throw new ExpressionException("Exception building AttributeExpression", this.getToken(0), ife);
                    }
                }
                case 20: {
                    return this.parseFunction(n);
                }
                case 9: {
                    return this.mathExpression((short)105);
                }
                case 10: {
                    return this.mathExpression((short)106);
                }
                case 11: {
                    return this.mathExpression((short)107);
                }
                case 12: {
                    return this.mathExpression((short)108);
                }
                case 1: {
                    return this.logicFilter((short)1);
                }
                case 2: {
                    return this.logicFilter((short)2);
                }
                case 13: {
                    return this.filter().not();
                }
                case 7: {
                    return this.compareFilter((short)17);
                }
                case 5: {
                    return this.compareFilter((short)15);
                }
                case 8: {
                    return this.compareFilter((short)18);
                }
                case 6: {
                    return this.compareFilter((short)16);
                }
                case 3: {
                    return this.compareFilter((short)14);
                }
                case 4: {
                    return this.compareFilter((short)23);
                }
                case 21: {
                    Token end = n.getToken();
                    while (end.next != null) {
                        end = end.next;
                    }
                    return this.geometry(n.getToken(), end);
                }
                case 17: 
                case 18: {
                    throw new ExpressionException("Unsupported syntax", this.getToken(0));
                }
            }
            return null;
        }

        LiteralExpression geometry(Token start, Token end) throws ExpressionException {
            if (this.reader == null) {
                this.reader = new WKTReader();
            }
            try {
                Geometry g = this.reader.read(this.input.substring(start.beginColumn - 1, end.endColumn));
                return this.factory.createLiteralExpression((Object)g);
            }
            catch (com.vividsolutions.jts.io.ParseException e) {
                throw new ExpressionException(e.getMessage(), start);
            }
            catch (Exception e) {
                throw new ExpressionException("Error building WKT Geometry", start, e);
            }
        }

        Object parseFunction(Node n) throws ExpressionException {
            String function = n.getToken().image;
            if ("box".equalsIgnoreCase(function)) {
                if (n.jjtGetNumChildren() != 4) {
                    throw new ExpressionException("Bounding Box filter requires 4 arguments", this.getToken(0));
                }
                double d4 = this.doubleValue();
                double d3 = this.doubleValue();
                double d2 = this.doubleValue();
                double d1 = this.doubleValue();
                try {
                    return this.factory.createBBoxExpression(new Envelope(d1, d2, d3, d4));
                }
                catch (IllegalFilterException ife) {
                    throw new ExpressionException("Exception building BBoxExpression", this.getToken(0), ife);
                }
            }
            if ("id".equalsIgnoreCase(function)) {
                if (n.jjtGetNumChildren() != 1) {
                    throw new ExpressionException("Feature ID filter requires 1 argument", this.getToken(0));
                }
                return this.factory.createFidFilter(this.stringValue());
            }
            if ("between".equalsIgnoreCase(function)) {
                if (n.jjtGetNumChildren() != 3) {
                    throw new ExpressionException("Between filter requires 3 arguments", this.getToken(0));
                }
                Expression two = this.expression();
                Expression att = this.expression();
                Expression one = this.expression();
                try {
                    BetweenFilter b = this.factory.createBetweenFilter();
                    b.addLeftValue(one);
                    b.addMiddleValue(att);
                    b.addRightValue(two);
                    return b;
                }
                catch (IllegalFilterException ife) {
                    throw new ExpressionException("Exception building BetweenFilter", this.getToken(0), ife);
                }
            }
            if ("like".equalsIgnoreCase(function)) {
                if (n.jjtGetNumChildren() != 2) {
                    throw new ExpressionException("Like filter requires at least two arguments", this.getToken(0));
                }
                LikeFilter f = this.factory.createLikeFilter();
                f.setPattern(this.stringValue(), "*", ".?", "//");
                try {
                    f.setValue(this.expression());
                }
                catch (IllegalFilterException ife) {
                    throw new ExpressionException("Exception building LikeFilter", this.getToken(0), ife);
                }
                return f;
            }
            if ("null".equalsIgnoreCase(function) || "isNull".equalsIgnoreCase(function)) {
                NullFilter nf = this.factory.createNullFilter();
                Expression e = this.expression();
                try {
                    if (e instanceof LiteralExpression) {
                        e = this.factory.createAttributeExpression(null, ((LiteralExpression)e).getValue(null).toString());
                    }
                    nf.nullCheckValue(e);
                }
                catch (IllegalFilterException ife) {
                    throw new ExpressionException("Exception building NullFilter", this.getToken(0), ife);
                }
                return nf;
            }
            short geometryFilterType = this.lookupGeometryFilter(function);
            if (geometryFilterType >= 0) {
                return this.buildGeometryFilter(geometryFilterType);
            }
            throw new ExpressionException("Could not build function : " + function, this.getToken(0));
        }

        short lookupGeometryFilter(String name) {
            Field[] f = (class$org$geotools$filter$AbstractFilter == null ? (class$org$geotools$filter$AbstractFilter = ExpressionBuilder.class$("org.geotools.filter.AbstractFilter")) : class$org$geotools$filter$AbstractFilter).getFields();
            name = name.toUpperCase();
            int ii = f.length;
            for (int i = 0; i < ii; ++i) {
                if (!f[i].getName().endsWith(name)) continue;
                try {
                    return f[i].getShort(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return -1;
        }

        GeometryFilter buildGeometryFilter(short type) throws ExpressionException {
            Expression right = this.expression();
            Expression left = this.expression();
            try {
                GeometryFilter f = this.factory.createGeometryFilter(type);
                f.addLeftGeometry(left);
                f.addRightGeometry(right);
                return f;
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building GeometryFilter", this.getToken(0), ife);
            }
        }
    }
}

