/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.shapefile.ShapefileDataStore;

public class ShapefileDataStoreFactory
implements DataStoreFactorySpi {
    public boolean canProcess(Map params) {
        boolean accept = false;
        if (params.containsKey("url")) {
            String url = (String)params.get("url");
            accept = url.toUpperCase().endsWith("SHP");
        }
        return accept;
    }

    public DataStore createDataStore(Map params) throws DataSourceException {
        ShapefileDataStore ds = null;
        if (this.canProcess(params)) {
            String location = (String)params.get("url");
            try {
                ds = new ShapefileDataStore(new URL(location));
            }
            catch (MalformedURLException mue) {
                throw new DataSourceException("Unable to attatch datastore to " + location, (Throwable)mue);
            }
        }
        return ds;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    public DataStoreFactorySpi.Param[] getParametersInfo() {
        return new DataStoreFactorySpi.Param[]{new DataStoreFactorySpi.Param("url", String.class, "url to a .shp file")};
    }
}

