/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceFactorySpi;
import org.geotools.data.shapefile.ShapefileDataSource;

public class ShapefileDataSourceFactory
implements DataSourceFactorySpi {
    public boolean canProcess(Map params) {
        boolean accept = false;
        if (params.containsKey("url")) {
            String url = (String)params.get("url");
            accept = url.toUpperCase().endsWith("SHP");
        }
        return accept;
    }

    public DataSource createDataSource(Map params) throws DataSourceException {
        ShapefileDataSource ds = null;
        if (this.canProcess(params)) {
            String location = (String)params.get("url");
            try {
                ds = new ShapefileDataSource(new URL(location));
            }
            catch (MalformedURLException mue) {
                throw new DataSourceException("Unable to attatch datasource to " + location, (Throwable)mue);
            }
        }
        return ds;
    }

    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }
}

