/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.cs.CoordinateSystemFactory;
import org.geotools.cs.FactoryException;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.HorizontalDatum;
import org.geotools.cv.SampleDimension;
import org.geotools.io.coverage.PropertyException;
import org.geotools.io.coverage.PropertyParser;

public class WorldFileParser
extends PropertyParser {
    boolean loaded = false;
    int dimension = 4;
    private static Logger LOGGER = Logger.getLogger("org.geotools.coverage");

    public WorldFileParser(File worldfile) throws IOException {
        this.load(worldfile);
    }

    protected void load(BufferedReader in) throws IOException {
        if (this.loaded) {
            return;
        }
        super.clear();
        this.addAlias(X_MINIMUM, "x-origin");
        this.addAlias(Y_MINIMUM, "y-origin");
        this.addAlias(X_MAXIMUM, "x-max");
        this.addAlias(Y_MAXIMUM, "y-max");
        this.addAlias(X_RESOLUTION, "x-res");
        this.addAlias(Y_RESOLUTION, "y-res");
        BufferedReader r = new BufferedReader(in);
        String line = r.readLine();
        double xres = Double.parseDouble(line.trim());
        line = r.readLine();
        line = r.readLine();
        line = r.readLine();
        double yres = Double.parseDouble(line);
        line = r.readLine();
        double x = Double.parseDouble(line);
        line = r.readLine();
        double my = Double.parseDouble(line);
        Double X = new Double(x);
        Double MY = new Double(my);
        Double XRes = new Double(xres);
        Double YRes = new Double(yres);
        LOGGER.fine("adding XMin " + X);
        LOGGER.fine("adding YMax " + MY);
        this.add("x-origin", X);
        this.add("y-max", MY);
        LOGGER.fine("adding X-res " + XRes);
        LOGGER.fine("adding Y-res " + YRes);
        this.add("x-res", XRes);
        this.add("y-res", YRes);
        try {
            CoordinateSystemFactory csf = CoordinateSystemFactory.getDefault();
            GeographicCoordinateSystem gcs = csf.createGeographicCoordinateSystem((CharSequence)"test", HorizontalDatum.WGS84);
            this.addAlias(UNITS, "units-i");
            this.add("units-i", "degrees");
            this.addAlias(DATUM, "datum-i");
            this.add("datum-i", gcs.getHorizontalDatum());
            this.addAlias(HEIGHT, "height-i");
            this.addAlias(WIDTH, "Width-i");
        }
        catch (FactoryException fe) {
            System.out.println("Factory Exception " + (Object)((Object)fe));
            LOGGER.severe("Factory Exception " + (Object)((Object)fe));
        }
        this.loaded = true;
    }

    public synchronized void clear() {
    }

    public void setHeight(int height) {
        LOGGER.fine("setting height " + height);
        try {
            this.add("height-i", new Integer(height));
            this.add("y-origin", new Double(this.getAsDouble(Y_MAXIMUM) + (double)height * this.getAsDouble(Y_RESOLUTION)));
            LOGGER.fine("ymin now " + this.getAsDouble(Y_MINIMUM));
        }
        catch (PropertyException e) {
            LOGGER.severe("property exception " + (Object)((Object)e));
        }
    }

    public void setWidth(int width) {
        LOGGER.fine("setting width " + width);
        try {
            this.add("width-i", new Integer(width));
        }
        catch (PropertyException e) {
            LOGGER.severe("property exception " + (Object)((Object)e));
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public SampleDimension[] getSampleDimensions() throws PropertyException {
        int dimension = this.getDimension();
        SampleDimension[] sd = new SampleDimension[dimension];
        for (int i = 0; i < dimension; ++i) {
            sd[i] = new SampleDimension();
        }
        return sd;
    }
}

