/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.WorldFileParser;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.Query;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.NullFilter;
import org.geotools.gc.GridCoverage;
import org.geotools.io.coverage.ExoreferencedGridCoverageReader;
import org.geotools.io.coverage.PropertyParser;

public class ImageDataSource
extends AbstractDataSource
implements DataSource {
    ExoreferencedGridCoverageReader reader;
    PropertyParser parser;
    File file;
    private static Logger LOGGER = Logger.getLogger("org.geotools.coverage");
    static FilterFactory filterFactory = FilterFactory.createFilterFactory();
    Envelope bbox;
    static FeatureType schema;
    static GeometryFactory geomFac;

    public ImageDataSource(String name) throws IOException {
        int index = name.lastIndexOf(46);
        String worldfile = index < 0 ? name + ".wld" : name.substring(0, index) + ".wld";
        this.load(name, worldfile);
    }

    public ImageDataSource(String name, String worldfile) throws IOException {
        this.load(name, worldfile);
    }

    private void load(String name, String worldfile) throws IOException {
        int index = name.lastIndexOf(".");
        String format = "";
        if (index > 0) {
            format = name.substring(index + 1, name.length());
        }
        this.parser = new WorldFileParser(new File(worldfile));
        RenderedOp image = JAI.create((String)"fileload", (Object)name);
        ((WorldFileParser)this.parser).setHeight(image.getHeight());
        ((WorldFileParser)this.parser).setWidth(image.getWidth());
        ((WorldFileParser)this.parser).setDimension(image.getSampleModel().getNumBands());
        this.reader = new ExoreferencedGridCoverageReader(format, this.parser);
        this.file = new File(name);
        this.reader.setInput((Object)this.file, false);
    }

    ArrayList loadFeatures(Filter filter) throws IOException, DataSourceException {
        if (filter == null) {
            filter = filterFactory.createNullFilter();
            try {
                ((NullFilter)filter).nullCheckValue((Expression)filterFactory.createAttributeExpression(schema, "geom"));
            }
            catch (IllegalFilterException e) {
                throw new DataSourceException("", (Throwable)e);
            }
            filter = filter.not();
        }
        int numb = this.reader.getNumImages(true);
        FeatureCollection features = FeatureCollections.newCollection();
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        for (int i = 0; i < numb; ++i) {
            org.geotools.pt.Envelope env = this.reader.getEnvelope(i);
            Envelope jenv = new Envelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1));
            if (this.bbox != null) {
                this.bbox.expandToInclude(jenv);
            } else {
                this.bbox = jenv;
            }
            LOGGER.fine("Xmin(pt) = " + env.getMinimum(0));
            LOGGER.fine("Xmin = " + jenv.getMinX());
            Coordinate[] c = new Coordinate[]{new Coordinate(jenv.getMinX(), jenv.getMinY()), new Coordinate(jenv.getMinX(), jenv.getMaxY()), new Coordinate(jenv.getMaxX(), jenv.getMaxY()), new Coordinate(jenv.getMaxX(), jenv.getMinY()), new Coordinate(jenv.getMinX(), jenv.getMinY())};
            LinearRing r = null;
            try {
                r = geomFac.createLinearRing(c);
            }
            catch (TopologyException e) {
                throw new DataSourceException(e.toString());
            }
            Polygon p = geomFac.createPolygon(r, null);
            try {
                Feature feature = schema.create(new Object[]{p, this.reader.getGridCoverage(i)});
                System.out.println("created " + feature);
                if (!filter.contains(feature)) continue;
                featuresList.add(feature);
                continue;
            }
            catch (IllegalAttributeException ife) {
                throw new DataSourceException("", (Throwable)ife);
            }
        }
        return featuresList;
    }

    public Envelope getBbox() {
        return this.bbox;
    }

    public Envelope getBbox(boolean speed) {
        try {
            if (speed) {
                return this.bbox;
            }
            this.bbox = new Envelope();
            int numb = this.reader.getNumImages(true);
            for (int i = 0; i < numb; ++i) {
                org.geotools.pt.Envelope env = this.reader.getEnvelope(i);
                Envelope jenv = new Envelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1));
                if (this.bbox != null) {
                    this.bbox.expandToInclude(jenv);
                    continue;
                }
                this.bbox = jenv;
            }
            return this.bbox;
        }
        catch (IOException e) {
            return null;
        }
    }

    public FeatureCollection getFeatures(Filter filter) throws DataSourceException {
        try {
            FeatureCollection collection = FeatureCollections.newCollection();
            collection.addAll((Collection)this.loadFeatures(filter));
            return collection;
        }
        catch (IOException e) {
            throw new DataSourceException("", (Throwable)e);
        }
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        Filter filter = null;
        if (query != null) {
            filter = query.getFilter();
        }
        try {
            if (collection == null) {
                collection = FeatureCollections.newCollection();
            }
            collection.addAll((Collection)this.loadFeatures(filter));
        }
        catch (IOException e) {
            throw new DataSourceException("", (Throwable)e);
        }
    }

    public FeatureType getSchema() {
        return null;
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport imgMeta = new AbstractDataSource.MetaDataSupport();
        imgMeta.setSupportsGetBbox(true);
        return imgMeta;
    }

    static {
        geomFac = new GeometryFactory();
        AttributeType geom = AttributeTypeFactory.newAttributeType((String)"geom", (Class)Polygon.class);
        AttributeType grid = AttributeTypeFactory.newAttributeType((String)"grid", (Class)GridCoverage.class);
        try {
            schema = FeatureTypeFactory.newFeatureType((AttributeType[])new AttributeType[]{geom, grid}, (String)"image");
        }
        catch (SchemaException e) {
            System.err.println("Help - unexpected schema exception thrown\n\t" + (Object)((Object)e));
        }
    }
}

