/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.Cloneable;
import org.geotools.util.EqualsUtils;

public class TextSymbolizerImpl
implements TextSymbolizer,
Cloneable {
    private static final FilterFactory filterFactory = FilterFactory.createFilterFactory();
    private Fill fill;
    private List fonts = new ArrayList();
    private Halo halo;
    private LabelPlacement labelPlacement;
    private String geometryPropertyName = null;
    private Expression label = null;

    protected TextSymbolizerImpl() {
        this.fill = new FillImpl();
        this.fill.setColor((Expression)filterFactory.createLiteralExpression("#000000"));
        this.halo = null;
        this.labelPlacement = new PointPlacementImpl();
    }

    public String geometryPropertyName() {
        return this.geometryPropertyName;
    }

    public Fill getFill() {
        return this.fill;
    }

    public void setFill(Fill fill) {
        this.fill = fill;
    }

    public Font[] getFonts() {
        if (this.fonts.size() == 0) {
            this.fonts.add(new FontImpl());
        }
        return this.fonts.toArray(new Font[0]);
    }

    public void addFont(Font font) {
        this.fonts.add(font);
    }

    public void setFonts(Font[] fonts) {
        this.fonts.clear();
        for (int i = 0; i < fonts.length; ++i) {
            this.addFont(fonts[i]);
        }
    }

    public Halo getHalo() {
        return this.halo;
    }

    public void setHalo(Halo halo) {
        this.halo = halo;
    }

    public Expression getLabel() {
        return this.label;
    }

    public void setLabel(Expression label) {
        this.label = label;
    }

    public LabelPlacement getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(LabelPlacement labelPlacement) {
        this.labelPlacement = labelPlacement;
    }

    public String getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    public void setGeometryPropertyName(String geometryPropertyName) {
        this.geometryPropertyName = geometryPropertyName;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((TextSymbolizer)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.fonts != null) {
            result = 1000003 * result + ((Object)this.fonts).hashCode();
        }
        if (this.halo != null) {
            result = 1000003 * result + this.halo.hashCode();
        }
        if (this.labelPlacement != null) {
            result = 1000003 * result + this.labelPlacement.hashCode();
        }
        if (this.geometryPropertyName != null) {
            result = 1000003 * result + this.geometryPropertyName.hashCode();
        }
        if (this.label != null) {
            result = 1000003 * result + this.label.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof TextSymbolizerImpl) {
            TextSymbolizerImpl other = (TextSymbolizerImpl)oth;
            return EqualsUtils.equals((Object)this.geometryPropertyName, (Object)other.geometryPropertyName) && EqualsUtils.equals((Object)this.label, (Object)other.label) && EqualsUtils.equals((Object)this.halo, (Object)other.halo) && EqualsUtils.equals((Object)this.fonts, (Object)other.fonts) && EqualsUtils.equals((Object)this.labelPlacement, (Object)other.labelPlacement) && EqualsUtils.equals((Object)this.fill, (Object)other.fill);
        }
        return false;
    }
}

