/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.URL;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Fill;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.Halo;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RasterSymbolizerImpl;
import org.geotools.styling.Rule;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleImpl;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizerImpl;

public class StyleFactoryImpl
extends StyleFactory {
    private static final FilterFactory filterFactory = FilterFactory.createFilterFactory();

    public Style createStyle() {
        return new StyleImpl();
    }

    public PointSymbolizer createPointSymbolizer() {
        return new PointSymbolizerImpl();
    }

    public PointSymbolizer createPointSymbolizer(Graphic graphic, String geometryPropertyName) {
        PointSymbolizerImpl pSymb = new PointSymbolizerImpl();
        pSymb.setGeometryPropertyName(geometryPropertyName);
        pSymb.setGraphic(graphic);
        return pSymb;
    }

    public PolygonSymbolizer createPolygonSymbolizer() {
        return new PolygonSymbolizerImpl();
    }

    public PolygonSymbolizer createPolygonSymbolizer(Stroke stroke, Fill fill, String geometryPropertyName) {
        PolygonSymbolizerImpl pSymb = new PolygonSymbolizerImpl();
        pSymb.setGeometryPropertyName(geometryPropertyName);
        pSymb.setStroke(stroke);
        pSymb.setFill(fill);
        return pSymb;
    }

    public LineSymbolizer createLineSymbolizer() {
        return new LineSymbolizerImpl();
    }

    public LineSymbolizer createLineSymbolizer(Stroke stroke, String geometryPropertyName) {
        LineSymbolizerImpl lSymb = new LineSymbolizerImpl();
        lSymb.setGeometryPropertyName(geometryPropertyName);
        lSymb.setStroke(stroke);
        return lSymb;
    }

    public TextSymbolizer createTextSymbolizer() {
        return new TextSymbolizerImpl();
    }

    public TextSymbolizer createTextSymbolizer(Fill fill, Font[] fonts, Halo halo, Expression label, LabelPlacement labelPlacement, String geometryPropertyName) {
        TextSymbolizerImpl tSymb = new TextSymbolizerImpl();
        tSymb.setFill(fill);
        tSymb.setFonts(fonts);
        tSymb.setGeometryPropertyName(geometryPropertyName);
        tSymb.setHalo(halo);
        tSymb.setLabel(label);
        tSymb.setLabelPlacement(labelPlacement);
        return tSymb;
    }

    public FeatureTypeStyle createFeatureTypeStyle() {
        return new FeatureTypeStyleImpl();
    }

    public FeatureTypeStyle createFeatureTypeStyle(Rule[] rules) {
        return new FeatureTypeStyleImpl(rules);
    }

    public Rule createRule() {
        return new RuleImpl();
    }

    public Stroke createStroke(Expression color, Expression width) {
        return this.createStroke(color, width, (Expression)filterFactory.createLiteralExpression(1.0));
    }

    public Stroke createStroke(Expression color, Expression width, Expression opacity) {
        return this.createStroke(color, width, opacity, (Expression)filterFactory.createLiteralExpression("miter"), (Expression)filterFactory.createLiteralExpression("butt"), null, (Expression)filterFactory.createLiteralExpression(0.0), null, null);
    }

    public Stroke createStroke(Expression color, Expression width, Expression opacity, Expression lineJoin, Expression lineCap, float[] dashArray, Expression dashOffset, Graphic graphicFill, Graphic graphicStroke) {
        StrokeImpl stroke = new StrokeImpl();
        if (color == null) {
            throw new IllegalArgumentException("Color may not be null in a stroke");
        }
        stroke.setColor(color);
        if (width == null) {
            throw new IllegalArgumentException("Width may not be null in a stroke");
        }
        stroke.setWidth(width);
        if (opacity == null) {
            throw new IllegalArgumentException("Opacity may not be null in a stroke");
        }
        stroke.setOpacity(opacity);
        if (lineJoin == null) {
            throw new IllegalArgumentException("LineJoin may not be null in a stroke");
        }
        stroke.setLineJoin(lineJoin);
        if (lineCap == null) {
            throw new IllegalArgumentException("LineCap may not be null in a stroke");
        }
        stroke.setLineCap(lineCap);
        stroke.setDashArray(dashArray);
        stroke.setDashOffset(dashOffset);
        stroke.setGraphicFill(graphicFill);
        stroke.setGraphicStroke(graphicStroke);
        return stroke;
    }

    public Fill createFill(Expression color, Expression backgroundColor, Expression opacity, Graphic graphicFill) {
        FillImpl fill = new FillImpl();
        if (color == null) {
            throw new IllegalArgumentException("Color may not be null in a fill");
        }
        fill.setColor(color);
        fill.setBackgroundColor(backgroundColor);
        if (opacity == null) {
            throw new IllegalArgumentException("Opacity may not be null in a fill");
        }
        fill.setOpacity(opacity);
        fill.setGraphicFill(graphicFill);
        return fill;
    }

    public Fill createFill(Expression color, Expression opacity) {
        return this.createFill(color, null, opacity, null);
    }

    public Fill createFill(Expression color) {
        return this.createFill(color, null, (Expression)filterFactory.createLiteralExpression(1.0), null);
    }

    public Mark createMark(Expression wellKnownName, Stroke stroke, Fill fill, Expression size, Expression rotation) {
        MarkImpl mark = new MarkImpl();
        if (wellKnownName == null) {
            throw new IllegalArgumentException("WellKnownName can not be null in mark");
        }
        mark.setWellKnownName(wellKnownName);
        mark.setStroke(stroke);
        mark.setFill(fill);
        if (size == null) {
            throw new IllegalArgumentException("Size can not be null in mark");
        }
        mark.setSize(size);
        if (rotation == null) {
            throw new IllegalArgumentException("Rotation can not be null in mark");
        }
        mark.setRotation(rotation);
        return mark;
    }

    public Mark getSquareMark() {
        Mark mark = this.createMark((Expression)filterFactory.createLiteralExpression("Square"), this.getDefaultStroke(), this.getDefaultFill(), (Expression)filterFactory.createLiteralExpression(6), (Expression)filterFactory.createLiteralExpression(0));
        return mark;
    }

    public Mark getCircleMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)filterFactory.createLiteralExpression("Circle"));
        return mark;
    }

    public Mark getCrossMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)filterFactory.createLiteralExpression("Cross"));
        return mark;
    }

    public Mark getXMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)filterFactory.createLiteralExpression("X"));
        return mark;
    }

    public Mark getTriangleMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)filterFactory.createLiteralExpression("Triangle"));
        return mark;
    }

    public Mark getStarMark() {
        Mark mark = this.getDefaultMark();
        mark.setWellKnownName((Expression)filterFactory.createLiteralExpression("Star"));
        return mark;
    }

    public Mark createMark() {
        MarkImpl mark = new MarkImpl();
        return mark;
    }

    public Graphic createGraphic(ExternalGraphic[] externalGraphics, Mark[] marks, Symbol[] symbols, Expression opacity, Expression size, Expression rotation) {
        GraphicImpl graphic = new GraphicImpl();
        graphic.setSymbols(symbols);
        graphic.setExternalGraphics(externalGraphics);
        graphic.setMarks(marks);
        if (opacity == null) {
            throw new IllegalArgumentException("Opacity can not be null in graphic");
        }
        graphic.setOpacity(opacity);
        if (size == null) {
            throw new IllegalArgumentException("Size can not be null in graphic");
        }
        graphic.setSize(size);
        if (rotation == null) {
            throw new IllegalArgumentException("Rotation can not be null in graphic");
        }
        graphic.setRotation(rotation);
        return graphic;
    }

    public ExternalGraphic createExternalGraphic(String uri, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setURI(uri);
        extg.setFormat(format);
        return extg;
    }

    public ExternalGraphic createExternalGraphic(URL url, String format) {
        ExternalGraphicImpl extg = new ExternalGraphicImpl();
        extg.setLocation(url);
        extg.setFormat(format);
        return extg;
    }

    public Font createFont(Expression fontFamily, Expression fontStyle, Expression fontWeight, Expression fontSize) {
        FontImpl font = new FontImpl();
        if (fontFamily == null) {
            throw new IllegalArgumentException("Null font family specified");
        }
        font.setFontFamily(fontFamily);
        if (fontSize == null) {
            throw new IllegalArgumentException("Null font size specified");
        }
        font.setFontSize(fontSize);
        if (fontStyle == null) {
            throw new IllegalArgumentException("Null font Style specified");
        }
        font.setFontStyle(fontStyle);
        if (fontWeight == null) {
            throw new IllegalArgumentException("Null font weight specified");
        }
        font.setFontWeight(fontWeight);
        return font;
    }

    public LinePlacement createLinePlacement(Expression offset) {
        LinePlacementImpl linep = new LinePlacementImpl();
        linep.setPerpendicularOffset(offset);
        return linep;
    }

    public PointPlacement createPointPlacement(AnchorPoint anchorPoint, Displacement displacement, Expression rotation) {
        PointPlacementImpl pointp = new PointPlacementImpl();
        pointp.setAnchorPoint(anchorPoint);
        pointp.setDisplacement(displacement);
        pointp.setRotation(rotation);
        return pointp;
    }

    public AnchorPoint createAnchorPoint(Expression x, Expression y) {
        AnchorPointImpl anchorPoint = new AnchorPointImpl();
        anchorPoint.setAnchorPointX(x);
        anchorPoint.setAnchorPointY(y);
        return anchorPoint;
    }

    public Displacement createDisplacement(Expression x, Expression y) {
        DisplacementImpl displacement = new DisplacementImpl();
        displacement.setDisplacementX(x);
        displacement.setDisplacementY(y);
        return displacement;
    }

    public Halo createHalo(Fill fill, Expression radius) {
        HaloImpl halo = new HaloImpl();
        halo.setFill(fill);
        halo.setRadius(radius);
        return halo;
    }

    public Fill getDefaultFill() {
        FillImpl fill = new FillImpl();
        try {
            fill.setColor((Expression)filterFactory.createLiteralExpression("#808080"));
            fill.setOpacity((Expression)filterFactory.createLiteralExpression((Object)new Double(1.0)));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating fill", ife);
        }
        return fill;
    }

    public LineSymbolizer getDefaultLineSymbolizer() {
        return this.createLineSymbolizer(this.getDefaultStroke(), null);
    }

    public Mark getDefaultMark() {
        return this.getSquareMark();
    }

    public PointSymbolizer getDefaultPointSymbolizer() {
        return this.createPointSymbolizer(this.getDefaultGraphic(), null);
    }

    public PolygonSymbolizer getDefaultPolygonSymbolizer() {
        return this.createPolygonSymbolizer(this.getDefaultStroke(), this.getDefaultFill(), null);
    }

    public Stroke getDefaultStroke() {
        try {
            Stroke stroke = this.createStroke((Expression)filterFactory.createLiteralExpression("#000000"), (Expression)filterFactory.createLiteralExpression((Object)new Integer(1)));
            stroke.setDashOffset((Expression)filterFactory.createLiteralExpression((Object)new Integer(0)));
            stroke.setLineCap((Expression)filterFactory.createLiteralExpression("butt"));
            stroke.setLineJoin((Expression)filterFactory.createLiteralExpression("miter"));
            stroke.setOpacity((Expression)filterFactory.createLiteralExpression((Object)new Integer(1)));
            return stroke;
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating stroke", ife);
        }
    }

    public Style getDefaultStyle() {
        Style style = this.createStyle();
        return style;
    }

    public TextSymbolizer getDefaultTextSymbolizer() {
        return this.createTextSymbolizer(this.getDefaultFill(), new Font[]{this.getDefaultFont()}, null, null, (LabelPlacement)this.getDefaultPointPlacement(), "geometry:text");
    }

    public Font getDefaultFont() {
        FontImpl font = new FontImpl();
        try {
            font.setFontSize((Expression)filterFactory.createLiteralExpression((Object)new Integer(10)));
            font.setFontStyle((Expression)filterFactory.createLiteralExpression("normal"));
            font.setFontWeight((Expression)filterFactory.createLiteralExpression("normal"));
            font.setFontFamily((Expression)filterFactory.createLiteralExpression("serif"));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating font", ife);
        }
        return font;
    }

    public Graphic getDefaultGraphic() {
        GraphicImpl graphic = new GraphicImpl();
        try {
            graphic.setSize((Expression)filterFactory.createLiteralExpression((Object)new Integer(6)));
            graphic.setOpacity((Expression)filterFactory.createLiteralExpression((Object)new Double(1.0)));
            graphic.setRotation((Expression)filterFactory.createLiteralExpression((Object)new Double(0.0)));
        }
        catch (IllegalFilterException ife) {
            throw new RuntimeException("Error creating graphic", ife);
        }
        return graphic;
    }

    public PointPlacement getDefaultPointPlacement() {
        return this.createPointPlacement(this.createAnchorPoint((Expression)filterFactory.createLiteralExpression(0), (Expression)filterFactory.createLiteralExpression(0.5)), this.createDisplacement((Expression)filterFactory.createLiteralExpression(0), (Expression)filterFactory.createLiteralExpression(0)), (Expression)filterFactory.createLiteralExpression(0));
    }

    public RasterSymbolizer createRasterSymbolizer(String geometryPropertyName, Expression opacity, ChannelSelection channel, Expression overlap, ColorMap colorMap, ContrastEnhancement cenhancement, ShadedRelief relief, Symbolizer outline) {
        RasterSymbolizerImpl rastersym = new RasterSymbolizerImpl();
        if (geometryPropertyName != null) {
            rastersym.setGeometryPropertyName(geometryPropertyName);
        }
        if (opacity != null) {
            rastersym.setOpacity(opacity);
        }
        if (channel != null) {
            rastersym.setChannelSelection(channel);
        }
        if (overlap != null) {
            rastersym.setOverlap(overlap);
        }
        if (colorMap != null) {
            rastersym.setColorMap(colorMap);
        }
        if (cenhancement != null) {
            rastersym.setContrastEnhancement(cenhancement);
        }
        if (relief != null) {
            rastersym.setShadedRelief(relief);
        }
        if (outline != null) {
            rastersym.setImageOutline(outline);
        }
        return rastersym;
    }

    public RasterSymbolizer getDefaultRasterSymbolizer() {
        return this.createRasterSymbolizer("geom", (Expression)filterFactory.createLiteralExpression(1.0), null, null, null, null, null, null);
    }

    public ChannelSelection createChannelSelection(SelectedChannelType[] channels) {
        ChannelSelectionImpl channelSel = new ChannelSelectionImpl();
        if (channels != null && channels.length > 0) {
            channelSel.setSelectedChannels(channels);
        }
        return channelSel;
    }

    public ColorMap createColorMap() {
        return new ColorMapImpl();
    }

    public SelectedChannelType createSelectedChannelType(String name, Expression enhancement) {
        SelectedChannelTypeImpl sct = new SelectedChannelTypeImpl();
        sct.setChannelName(name);
        sct.setContrastEnhancement(enhancement);
        return sct;
    }
}

