/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import java.util.Arrays;
import org.geotools.feature.Feature;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.styling.Graphic;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Cloneable;

public class StrokeImpl
implements Stroke,
Cloneable {
    private static final FilterFactory filterFactory = FilterFactory.createFilterFactory();
    private Expression color;
    private float[] dashArray;
    private Expression dashOffset;
    private Graphic fillGraphic;
    private Graphic strokeGraphic;
    private Expression lineCap;
    private Expression lineJoin;
    private Expression opacity;
    private Expression width;

    protected StrokeImpl() {
    }

    public Expression getColor() {
        return this.color;
    }

    public void setColor(Expression color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    public void setColor(String color) {
        this.setColor((Expression)filterFactory.createLiteralExpression(color));
    }

    public float[] getDashArray() {
        float[] ret = new float[]{};
        if (this.dashArray != null) {
            ret = new float[this.dashArray.length];
            System.arraycopy(this.dashArray, 0, ret, 0, this.dashArray.length);
        }
        return ret;
    }

    public void setDashArray(float[] dashPattern) {
        this.dashArray = dashPattern;
    }

    public Expression getDashOffset() {
        return this.dashOffset;
    }

    public void setDashOffset(Expression offset) {
        if (offset == null) {
            return;
        }
        this.dashOffset = offset;
    }

    public Graphic getGraphicFill() {
        return this.fillGraphic;
    }

    public void setGraphicFill(Graphic graphic) {
        this.fillGraphic = graphic;
    }

    public Graphic getGraphicStroke() {
        return this.strokeGraphic;
    }

    public void setGraphicStroke(Graphic graphic) {
        this.strokeGraphic = graphic;
    }

    public Expression getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(Expression cap) {
        if (cap == null) {
            return;
        }
        this.lineCap = cap;
    }

    public Expression getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(Expression join) {
        if (join == null) {
            return;
        }
        this.lineJoin = join;
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Expression level) {
        if (level == null) {
            return;
        }
        this.opacity = level;
    }

    public Expression getWidth() {
        return this.width;
    }

    public void setWidth(Expression expr) {
        if (expr == null) {
            return;
        }
        this.width = expr;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("org.geotools.styling.StrokeImpl:\n");
        out.append("\tColor " + this.color + "\n");
        out.append("\tWidth " + this.width + "\n");
        out.append("\tOpacity " + this.opacity + "\n");
        out.append("\tLineCap " + this.lineCap + "\n");
        out.append("\tLineJoin " + this.lineJoin + "\n");
        out.append("\tDash Array " + this.dashArray + "\n");
        out.append("\tDash Offset " + this.dashOffset + "\n");
        out.append("\tFill Graphic " + this.fillGraphic + "\n");
        out.append("\tStroke Graphic " + this.strokeGraphic);
        return out.toString();
    }

    public Color getColor(Feature feature) {
        return Color.decode((String)this.getColor().getValue(feature));
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Stroke)this);
    }

    public Object clone() {
        try {
            StrokeImpl clone = (StrokeImpl)super.clone();
            if (this.dashArray != null) {
                clone.dashArray = new float[this.dashArray.length];
                System.arraycopy(this.dashArray, 0, clone.dashArray, 0, this.dashArray.length);
            }
            if (this.fillGraphic != null) {
                clone.fillGraphic = (Graphic)((Cloneable)this.fillGraphic).clone();
            }
            if (this.strokeGraphic != null) {
                clone.strokeGraphic = (Graphic)((Cloneable)this.strokeGraphic).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone StrokeImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.dashOffset != null) {
            result = 1000003 * result + this.dashOffset.hashCode();
        }
        if (this.fillGraphic != null) {
            result = 1000003 * result + this.fillGraphic.hashCode();
        }
        if (this.strokeGraphic != null) {
            result = 1000003 * result + this.strokeGraphic.hashCode();
        }
        if (this.lineCap != null) {
            result = 1000003 * result + this.lineCap.hashCode();
        }
        if (this.lineJoin != null) {
            result = 1000003 * result + this.lineJoin.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.width != null) {
            result = 1000003 * result + this.width.hashCode();
        }
        if (this.dashArray != null) {
            result = 1000003 * result + this.hashCodeDashArray(this.dashArray);
        }
        return result;
    }

    private int hashCodeDashArray(float[] a) {
        int PRIME = 1000003;
        if (a == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result = 1000003 * result + Float.floatToIntBits(a[i]);
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        StrokeImpl other = (StrokeImpl)oth;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.width == null ? other.width != null : !this.width.equals(other.width)) {
            return false;
        }
        if (this.dashOffset == null ? other.dashOffset != null : !this.dashOffset.equals(other.dashOffset)) {
            return false;
        }
        if (this.lineCap == null ? other.lineCap != null : !this.lineCap.equals(other.lineCap)) {
            return false;
        }
        if (this.lineJoin == null ? other.lineJoin != null : !this.lineJoin.equals(other.lineJoin)) {
            return false;
        }
        if (this.opacity == null ? other.opacity != null : !this.opacity.equals(other.opacity)) {
            return false;
        }
        if (this.fillGraphic == null ? other.fillGraphic != null : !this.fillGraphic.equals(other.fillGraphic)) {
            return false;
        }
        if (this.strokeGraphic == null ? other.strokeGraphic != null : !this.strokeGraphic.equals(other.strokeGraphic)) {
            return false;
        }
        return Arrays.equals(this.dashArray, other.dashArray);
    }
}

