/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Cloneable;
import org.geotools.util.EqualsUtils;

public class FillImpl
implements Fill,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private static final FilterFactory filterFactory = FilterFactory.createFilterFactory();
    private Expression color = null;
    private Expression backgroundColor = null;
    private Expression opacity = null;
    private Graphic graphicFill = null;

    protected FillImpl() {
    }

    public Expression getColor() {
        return this.color;
    }

    public void setColor(Expression rgb) {
        this.color = rgb;
    }

    public void setColor(String rgb) {
        this.color = filterFactory.createLiteralExpression(rgb);
    }

    public Expression getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Expression rgb) {
        this.backgroundColor = rgb;
    }

    public void setBackgroundColor(String rgb) {
        LOGGER.fine("setting bg color with " + rgb + " as a string");
        this.backgroundColor = filterFactory.createLiteralExpression(rgb);
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Expression opacity) {
        this.opacity = opacity;
    }

    public void setOpacity(String opacity) {
        this.opacity = filterFactory.createLiteralExpression(opacity);
    }

    public Graphic getGraphicFill() {
        return this.graphicFill;
    }

    public void setGraphicFill(Graphic graphicFill) {
        this.graphicFill = graphicFill;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Fill)this);
    }

    public Object clone() {
        try {
            FillImpl clone = (FillImpl)super.clone();
            if (this.graphicFill != null) {
                clone.graphicFill = (Graphic)((Cloneable)this.graphicFill).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone FillImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.color != null) {
            result = 1000003 * result + this.color.hashCode();
        }
        if (this.backgroundColor != null) {
            result = 1000003 * result + this.backgroundColor.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        if (this.graphicFill != null) {
            result = 1000003 * result + this.graphicFill.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof FillImpl) {
            FillImpl other = (FillImpl)oth;
            return EqualsUtils.equals((Object)this.color, (Object)other.color) && EqualsUtils.equals((Object)this.backgroundColor, (Object)other.backgroundColor) && EqualsUtils.equals((Object)this.opacity, (Object)other.opacity) && EqualsUtils.equals((Object)this.graphicFill, (Object)other.graphicFill);
        }
        return false;
    }
}

