/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.Map;
import org.geotools.renderer.Renderer;
import org.geotools.styling.Style;
import org.opengis.cs.CS_CoordinateSystem;

public class DefaultMap
implements Map {
    private Hashtable tables = new Hashtable();
    private List tableOrder = new ArrayList();

    public void addFeatureTable(FeatureCollection ft, Style style) throws IllegalArgumentException {
        if (ft == null) {
            throw new IllegalArgumentException("Feature Collection can not be null in DefaultMap.addFeatureTable");
        }
        if (style == null) {
            throw new IllegalArgumentException("Style can not be null in DefaultMap.addFeatureTable");
        }
        this.tables.put(ft, style);
        this.tableOrder.add(ft);
    }

    public void removeFeatureTable(FeatureCollection fc) {
        this.tables.remove(fc);
        this.tableOrder.remove(fc);
    }

    public void render(Renderer renderer, Envelope envelope) {
        Iterator layers = this.tableOrder.iterator();
        while (layers.hasNext()) {
            FeatureCollection fc = (FeatureCollection)layers.next();
            Style style = (Style)this.tables.get(fc);
            renderer.render(fc, envelope, style);
        }
    }

    public void setCoordinateSystem(CS_CoordinateSystem cs) {
    }
}

