/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.map.Layer;
import org.geotools.map.LayerList;
import org.geotools.map.event.LayerListEvent;
import org.geotools.map.event.LayerListListener;

public class DefaultLayerList
implements LayerList,
CollectionListener {
    private final List layers = Collections.synchronizedList(new ArrayList());
    private Envelope bounds;
    private EventListenerList listenerList;

    public DefaultLayerList() {
    }

    public DefaultLayerList(Layer layer) {
        this.addLayer(layer);
    }

    public DefaultLayerList(Layer[] layers) {
        this.addLayers(layers);
    }

    public void addLayer(Layer layer) {
        layer.getFeatures().addListener((CollectionListener)this);
        this.layers.add(layer);
        this.fireLayerListChanged();
    }

    public void removeLayer(Layer layer) {
        layer.getFeatures().removeListener((CollectionListener)this);
        this.layers.remove(layer);
        this.fireLayerListChanged();
    }

    public void addLayers(Layer[] layers) {
        if (layers != null) {
            for (int i = 0; i < layers.length; ++i) {
                Layer layer = layers[i];
                layer.getFeatures().addListener((CollectionListener)this);
                this.layers.add(layer);
            }
            this.fireLayerListChanged();
        }
    }

    public void removeLayers(Layer[] layers) {
        if (layers != null) {
            for (int i = 0; i < layers.length; ++i) {
                Layer layer = layers[i];
                layer.getFeatures().removeListener((CollectionListener)this);
                this.layers.remove(layer);
            }
            this.fireLayerListChanged();
        }
    }

    public Layer[] getLayers() {
        return this.layers.toArray(new Layer[this.layers.size()]);
    }

    public Envelope getBounds() {
        if (this.bounds == null) {
            Iterator it = this.layers.iterator();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                Envelope toAdd = layer.getFeatures().getBounds();
                if (toAdd == null) {
                    return null;
                }
                if (this.bounds == null) {
                    this.bounds = new Envelope(toAdd);
                    continue;
                }
                this.bounds.expandToInclude(toAdd);
            }
        }
        return this.bounds;
    }

    public Envelope getBbox() {
        return this.getBounds();
    }

    public void collectionChanged(CollectionEvent event) {
        this.bounds = null;
    }

    public void addLayerListListener(LayerListListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
            this.listenerList.add(LayerListListener.class, listener);
        }
    }

    public void removeLayerListListener(LayerListListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(LayerListListener.class, listener);
            if (this.listenerList.getListenerCount() == 0) {
                this.listenerList = null;
            }
        }
    }

    public void addLayerListChangedListener(LayerListListener llce) {
        this.addLayerListListener(llce);
    }

    public void removeLayerListChangedListener(LayerListListener llcl) {
        this.removeLayerListListener(llcl);
    }

    protected void fireLayerListChanged() {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            LayerListEvent event = null;
            int i = listeners.length;
            while ((i -= 2) >= 0) {
                if (listeners[i] != (class$org$geotools$map$event$LayerListListener == null ? DefaultLayerList.class$("org.geotools.map.event.LayerListListener") : class$org$geotools$map$event$LayerListListener)) continue;
                if (event == null) {
                    event = new LayerListEvent((Object)this);
                }
                ((LayerListListener)listeners[i + 1]).layerListChanged((EventObject)event);
            }
        }
    }
}

