/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.EventObject;
import javax.swing.event.EventListenerList;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.Layer;
import org.geotools.map.event.LayerEvent;
import org.geotools.map.event.LayerListener;
import org.geotools.resources.Utilities;
import org.geotools.styling.Style;

public class DefaultLayer
implements Layer {
    private FeatureCollection features;
    private Style style;
    private String title;
    private boolean visible = true;
    private EventListenerList listenerList;

    protected DefaultLayer(FeatureCollection features, Style style) throws IllegalArgumentException {
        if (style == null || features == null) {
            throw new IllegalArgumentException();
        }
        this.features = features;
        this.style = style;
    }

    public FeatureCollection getFeatures() {
        return this.features;
    }

    public Style getStyle() {
        return this.style;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public void setTitle(String title) {
        if (!Utilities.equals((Object)this.title, (Object)title)) {
            this.title = title;
            this.fireLayerChanged(2);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.fireLayerChanged(1);
        }
    }

    public boolean getVisability() {
        return this.isVisible();
    }

    public void setVisability(boolean visability) {
        this.setVisible(visability);
    }

    public void addLayerListener(LayerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
            this.listenerList.add(LayerListener.class, listener);
        }
    }

    public void removeLayerListener(LayerListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(LayerListener.class, listener);
            if (this.listenerList.getListenerCount() == 0) {
                this.listenerList = null;
            }
        }
    }

    public void addLayerChangedListener(LayerListener llce) {
        this.addLayerListener(llce);
    }

    public void removeLayerChangedListener(LayerListener llcl) {
        this.removeLayerListener(llcl);
    }

    protected void fireLayerChanged(int reason) {
        if (this.listenerList != null) {
            int method = reason == 1 ? (this.visible ? 1 : 2) : 0;
            Object[] listeners = this.listenerList.getListenerList();
            LayerEvent event = null;
            int i = listeners.length;
            block5: while ((i -= 2) >= 0) {
                if (listeners[i] != (class$org$geotools$map$event$LayerListener == null ? DefaultLayer.class$("org.geotools.map.event.LayerListener") : class$org$geotools$map$event$LayerListener)) continue;
                if (event == null) {
                    event = new LayerEvent((Object)this, reason);
                }
                LayerListener listener = (LayerListener)listeners[i + 1];
                switch (method) {
                    case 0: {
                        listener.layerChanged((EventObject)event);
                        continue block5;
                    }
                    case 1: {
                        listener.layerShown((EventObject)event);
                        continue block5;
                    }
                    case 2: {
                        listener.layerHidden((EventObject)event);
                        continue block5;
                    }
                }
                throw new AssertionError(method);
            }
        }
    }

    public String toString() {
        if (this.title == null) {
            return Utilities.getShortClassName((Object)this);
        }
        return this.title;
    }
}

