/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.BoundingBox;
import org.geotools.map.Context;
import org.geotools.map.ContextFactory;
import org.geotools.map.DefaultBoundingBox;
import org.geotools.map.DefaultContext;
import org.geotools.map.DefaultLayer;
import org.geotools.map.DefaultLayerList;
import org.geotools.map.Layer;
import org.geotools.map.LayerList;
import org.geotools.styling.Style;
import org.opengis.cs.CS_CoordinateSystem;

public class DefaultContextFactory
extends ContextFactory {
    private BoundingBox createBoundingBox(Envelope bounds, CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        return new DefaultBoundingBox(bounds, coordinateSystem);
    }

    public BoundingBox createBoundingBox(Envelope bounds, CS_CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        return new DefaultBoundingBox(bounds, coordinateSystem);
    }

    public Context createContext(BoundingBox bounds, LayerList layerList, String title, String cabstract, String[] keywords, String contactInformation) throws IllegalArgumentException {
        return new DefaultContext(bounds, layerList, title, cabstract, keywords, contactInformation);
    }

    public Context createContext() {
        GeographicCoordinateSystem cs = GeographicCoordinateSystem.WGS84;
        org.geotools.pt.Envelope envelope = cs.getDefaultEnvelope();
        Envelope envelope2 = new Envelope(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1));
        return this.createContext(this.createBoundingBox(envelope2, (CoordinateSystem)cs), this.createLayerList(), "", "", null, "");
    }

    public Layer createLayer(FeatureCollection features, Style style) throws IllegalArgumentException {
        return new DefaultLayer(features, style);
    }

    public LayerList createLayerList() {
        return new DefaultLayerList();
    }
}

