/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import org.geotools.map.BoundingBox;
import org.geotools.map.Context;
import org.geotools.map.LayerList;

public class DefaultContext
implements Context {
    private BoundingBox bbox;
    private LayerList layerList;
    private String title;
    private String conAbstract;
    private String contactInformation;
    private String[] keywords;

    protected DefaultContext(BoundingBox bbox, LayerList layerList, String title, String conAbstract, String[] keywords, String contactInformation) throws IllegalArgumentException {
        if (bbox == null || layerList == null || title == null) {
            throw new IllegalArgumentException();
        }
        this.bbox = bbox;
        this.layerList = layerList;
        this.setTitle(title);
        this.setAbstract(conAbstract);
        this.setKeywords(keywords);
        this.setContactInformation(contactInformation);
    }

    public BoundingBox getBbox() {
        return this.getBoundingBox();
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    public LayerList getLayerList() {
        return this.layerList;
    }

    public String getAbstract() {
        if (this.conAbstract == null) {
            return "";
        }
        return this.conAbstract;
    }

    public void setAbstract(String conAbstract) {
        this.conAbstract = conAbstract;
    }

    public String getContactInformation() {
        if (this.contactInformation == null) {
            return "";
        }
        return this.contactInformation;
    }

    public void setContactInformation(String contactInformation) {
        this.contactInformation = contactInformation;
    }

    public String[] getKeywords() {
        if (this.keywords == null) {
            return new String[0];
        }
        return (String[])this.keywords.clone();
    }

    public void setKeywords(String[] keywords) {
        if (keywords != null) {
            keywords = (String[])keywords.clone();
        }
        this.keywords = keywords;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

