/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import javax.swing.event.EventListenerList;
import org.geotools.cs.CoordinateSystem;
import org.geotools.cs.Info;
import org.geotools.ct.Adapters;
import org.geotools.ct.MathTransform;
import org.geotools.ct.MathTransform2D;
import org.geotools.ct.MathTransformFactory;
import org.geotools.ct.TransformException;
import org.geotools.map.BoundingBox;
import org.geotools.map.event.BoundingBoxEvent;
import org.geotools.map.event.BoundingBoxListener;
import org.geotools.resources.CTSUtilities;
import org.geotools.util.Cloneable;
import org.opengis.cs.CS_CoordinateSystem;
import org.opengis.ct.CT_MathTransform;

public class DefaultBoundingBox
implements BoundingBox,
Cloneable {
    private Envelope areaOfInterest;
    private CoordinateSystem coordinateSystem;
    private EventListenerList listenerList;

    protected DefaultBoundingBox(Envelope areaOfInterest, CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        this.setAreaOfInterest(areaOfInterest, coordinateSystem);
    }

    protected DefaultBoundingBox(Envelope areaOfInterest, CS_CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        this.setAreaOfInterest(areaOfInterest, coordinateSystem);
    }

    private void setAreaOfInterest(Envelope areaOfInterest, CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        MathTransform2D transform;
        if (areaOfInterest == null || coordinateSystem == null || areaOfInterest.isNull()) {
            throw new IllegalArgumentException();
        }
        if (this.areaOfInterest == null || this.coordinateSystem == null || !this.coordinateSystem.equals((Info)coordinateSystem, false)) {
            transform = null;
        } else {
            AffineTransform at = AffineTransform.getTranslateInstance(areaOfInterest.getMinX(), areaOfInterest.getMinY());
            at.scale(areaOfInterest.getWidth() / this.areaOfInterest.getWidth(), areaOfInterest.getHeight() / this.areaOfInterest.getHeight());
            at.translate(-this.areaOfInterest.getMinX(), -this.areaOfInterest.getMinY());
            transform = MathTransformFactory.getDefault().createAffineTransform(at);
        }
        this.areaOfInterest = new Envelope(areaOfInterest);
        this.coordinateSystem = coordinateSystem;
        this.fireAreaOfInterestChanged(transform);
    }

    public void setAreaOfInterest(Envelope areaOfInterest, CS_CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        try {
            this.setAreaOfInterest(areaOfInterest, Adapters.getDefault().wrap(coordinateSystem));
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e, "Remote call failed");
        }
    }

    public void setAreaOfInterest(Envelope areaOfInterest) {
        this.setAreaOfInterest(areaOfInterest, this.coordinateSystem);
    }

    public Envelope getAreaOfInterest() {
        return new Envelope(this.areaOfInterest);
    }

    public CS_CoordinateSystem getCoordinateSystem() {
        try {
            return Adapters.getDefault().export(this.coordinateSystem);
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e, "Remote call failed");
        }
    }

    public void transform(MathTransform2D transform) throws TransformException {
        Rectangle2D area = new Rectangle2D.Double(this.areaOfInterest.getMinX(), this.areaOfInterest.getMinY(), this.areaOfInterest.getWidth(), this.areaOfInterest.getHeight());
        area = CTSUtilities.transform((MathTransform2D)transform, (Rectangle2D)area, (Rectangle2D)area);
        this.areaOfInterest = new Envelope(area.getMinX(), area.getMaxX(), area.getMinY(), area.getMaxY());
        this.fireAreaOfInterestChanged(transform);
    }

    public void transform(CT_MathTransform transform) {
        try {
            this.transform((MathTransform2D)Adapters.getDefault().wrap(transform));
        }
        catch (RemoteException e) {
            throw new UndeclaredThrowableException(e, "Remote call failed");
        }
        catch (TransformException e) {
            throw new UndeclaredThrowableException(e, "Transformation failed");
        }
    }

    public void addBoundingBoxListener(BoundingBoxListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(BoundingBoxListener.class, listener);
    }

    public void removeBoundingBoxListener(BoundingBoxListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(BoundingBoxListener.class, listener);
            if (this.listenerList.getListenerCount() == 0) {
                this.listenerList = null;
            }
        }
    }

    public void addAreaOfInterestChangedListener(BoundingBoxListener ecl, boolean sendEvent) {
        this.addAreaOfInterestChangedListener(ecl);
        if (sendEvent) {
            this.fireAreaOfInterestChanged(null);
        }
    }

    public void addAreaOfInterestChangedListener(BoundingBoxListener ecl) {
        this.addBoundingBoxListener(ecl);
    }

    public void removeAreaOfInterestChangedListener(BoundingBoxListener ecl) {
        this.removeBoundingBoxListener(ecl);
    }

    protected void fireAreaOfInterestChanged(MathTransform2D transform) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            BoundingBoxEvent event = null;
            int i = listeners.length;
            while ((i -= 2) >= 0) {
                if (listeners[i] != (class$org$geotools$map$event$BoundingBoxListener == null ? DefaultBoundingBox.class$("org.geotools.map.event.BoundingBoxListener") : class$org$geotools$map$event$BoundingBoxListener)) continue;
                if (event == null) {
                    try {
                        event = new BoundingBoxEvent((Object)this, Adapters.getDefault().export((MathTransform)transform));
                    }
                    catch (RemoteException exception) {
                        throw new UndeclaredThrowableException(exception, "Remote call failed");
                    }
                }
                ((BoundingBoxListener)listeners[i + 1]).areaOfInterestChanged(event);
            }
        }
    }

    public Object clone() {
        return new DefaultBoundingBox(this.areaOfInterest, this.coordinateSystem);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(this.areaOfInterest.getMinX());
        buffer.append(',');
        buffer.append(this.areaOfInterest.getMinY());
        buffer.append("),(");
        buffer.append(this.areaOfInterest.getMaxX());
        buffer.append(',');
        buffer.append(this.areaOfInterest.getMaxY());
        buffer.append(')');
        return buffer.toString();
    }
}

