/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.NullFilter;

public class NullFilterImpl
extends AbstractFilterImpl
implements NullFilter {
    private Expression nullCheck = null;

    protected NullFilterImpl() {
        this.filterType = (short)21;
    }

    public void nullCheckValue(Expression nullCheck) throws IllegalFilterException {
        if (!(nullCheck instanceof AttributeExpression)) {
            throw new IllegalFilterException("Attempted to add non-attribute expression to a null filter.");
        }
        this.nullCheck = nullCheck;
    }

    public Expression getNullCheckValue() {
        return this.nullCheck;
    }

    public boolean contains(Feature feature) {
        if (this.nullCheck == null) {
            return false;
        }
        return this.nullCheck.getValue(feature) == null;
    }

    public String toString() {
        return "[ " + this.nullCheck.toString() + " is null ]";
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == ((Object)((Object)this)).getClass()) {
            NullFilterImpl nullFilter = (NullFilterImpl)((Object)obj);
            return nullFilter.getFilterType() == this.filterType && nullFilter.getNullCheckValue().equals(this.nullCheck);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.nullCheck == null ? 0 : this.nullCheck.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit((NullFilter)this);
    }
}

