/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.MathExpression;

public class MathExpressionImpl
extends DefaultExpression
implements MathExpression {
    private Expression leftValue = null;
    private Expression rightValue = null;

    protected MathExpressionImpl() {
    }

    protected MathExpressionImpl(short expType) throws IllegalFilterException {
        if (!MathExpressionImpl.isMathExpression((short)expType)) {
            throw new IllegalFilterException("Attempted to add non-math expression to math expression.");
        }
        this.expressionType = expType;
    }

    public void addLeftValue(Expression leftValue) throws IllegalFilterException {
        if (MathExpressionImpl.isGeometryExpression((short)leftValue.getType()) || leftValue.getType() == 103) {
            throw new IllegalFilterException("Attempted to add Geometry or String expression to math expression.");
        }
        this.leftValue = leftValue;
    }

    public void addRightValue(Expression rightValue) throws IllegalFilterException {
        if (MathExpressionImpl.isGeometryExpression((short)rightValue.getType()) || rightValue.getType() == 103) {
            throw new IllegalFilterException("Attempted to add Geometry or String sub expression to math expression.");
        }
        this.rightValue = rightValue;
    }

    public Expression getLeftValue() {
        return this.leftValue;
    }

    public Expression getRightValue() {
        return this.rightValue;
    }

    public short getType() {
        return this.expressionType;
    }

    public Object getValue(Feature feature) throws IllegalArgumentException {
        if (this.leftValue == null || this.rightValue == null) {
            throw new IllegalArgumentException("Attempted read math expression with missing sub expressions.");
        }
        double leftDouble = ((Number)this.leftValue.getValue(feature)).doubleValue();
        double rightDouble = ((Number)this.rightValue.getValue(feature)).doubleValue();
        if (this.expressionType == 105) {
            return new Double(leftDouble + rightDouble);
        }
        if (this.expressionType == 106) {
            return new Double(leftDouble - rightDouble);
        }
        if (this.expressionType == 107) {
            return new Double(leftDouble * rightDouble);
        }
        if (this.expressionType == 108) {
            return new Double(leftDouble / rightDouble);
        }
        throw new IllegalArgumentException("Attempted read math expression with invalid type (ie. Add, Subtract, etc.).");
    }

    public String toString() {
        String operation;
        switch (this.expressionType) {
            case 105: {
                operation = " + ";
                break;
            }
            case 106: {
                operation = " - ";
                break;
            }
            case 107: {
                operation = " * ";
                break;
            }
            case 108: {
                operation = " / ";
                break;
            }
            default: {
                operation = " ? ";
            }
        }
        return "(" + this.leftValue.toString() + operation + this.rightValue.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof MathExpressionImpl) {
            MathExpression expMath = (MathExpression)obj;
            return expMath.getType() == this.expressionType && expMath.getLeftValue().equals(this.leftValue) && expMath.getRightValue().equals(this.rightValue);
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result = 37 * result + this.expressionType;
        result = 37 * result + this.leftValue.hashCode();
        result = 37 * result + this.rightValue.hashCode();
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit((MathExpression)this);
    }
}

