/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;

public class GeometryFilterImpl
extends AbstractFilterImpl
implements GeometryFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter");
    protected Expression leftGeometry = null;
    protected Expression rightGeometry = null;

    protected GeometryFilterImpl(short filterType) throws IllegalFilterException {
        if (!GeometryFilterImpl.isGeometryFilter((short)filterType)) {
            throw new IllegalFilterException("Attempted to create geometry filter with non-geometry type.");
        }
        this.filterType = filterType;
    }

    public void addLeftGeometry(Expression leftGeometry) throws IllegalFilterException {
        if (!DefaultExpression.isGeometryExpression((short)leftGeometry.getType()) && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add (left) non-geometry expression to geometry filter.");
        }
        this.leftGeometry = leftGeometry;
    }

    public void addRightGeometry(Expression rightGeometry) throws IllegalFilterException {
        if (!DefaultExpression.isGeometryExpression((short)rightGeometry.getType()) && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add (right) non-geometryexpression to geometry filter.");
        }
        this.rightGeometry = rightGeometry;
    }

    public Expression getLeftGeometry() {
        return this.leftGeometry;
    }

    public Expression getRightGeometry() {
        return this.rightGeometry;
    }

    public boolean contains(Feature feature) {
        Geometry right = null;
        right = this.rightGeometry != null ? (Geometry)this.rightGeometry.getValue(feature) : feature.getDefaultGeometry();
        Geometry left = null;
        if (this.leftGeometry != null) {
            Object obj = this.leftGeometry.getValue(feature);
            left = (Geometry)obj;
        } else {
            left = feature.getDefaultGeometry();
        }
        if (this.filterType == 5) {
            return left.equals(right);
        }
        if (this.filterType == 6) {
            return left.disjoint(right);
        }
        if (this.filterType == 7) {
            return left.intersects(right);
        }
        if (this.filterType == 9) {
            return left.crosses(right);
        }
        if (this.filterType == 10) {
            return left.within(right);
        }
        if (this.filterType == 11) {
            return left.contains(right);
        }
        if (this.filterType == 12) {
            return left.overlaps(right);
        }
        if (this.filterType == 8) {
            return left.touches(right);
        }
        if (this.filterType == 4) {
            Coordinate[] cr = right.getEnvelope().getCoordinates();
            Coordinate[] cl = left.getEnvelope().getCoordinates();
            if (left.getDimension() >= 1) {
                if (cl[0].x >= cr[0].x && cl[2].x <= cr[2].x && cl[0].y >= cr[0].y && cl[2].y <= cr[2].y) {
                    return true;
                }
                if (cl[0].x > cr[2].x || cl[2].x < cr[0].x || cl[0].y > cr[2].y || cl[2].y < cr[0].y) {
                    return false;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Right: [" + cr[0].x + "," + cr[0].y + "]" + "-" + "[" + cr[3].x + "," + cr[3].y + "]");
                    LOGGER.finer("Left: [" + cl[0].x + "," + cl[0].y + "]" + "-" + "[" + cl[3].x + "," + cl[3].y + "]");
                }
                return left.intersects(right);
            }
            return left.intersects(right);
        }
        return true;
    }

    public String toString() {
        String operator = null;
        if (this.filterType == 5) {
            operator = " equals ";
        } else if (this.filterType == 6) {
            operator = " disjoint ";
        } else if (this.filterType == 7) {
            operator = " intersects ";
        } else if (this.filterType == 9) {
            operator = " crosses ";
        } else if (this.filterType == 10) {
            operator = " within ";
        } else if (this.filterType == 11) {
            operator = " contains ";
        } else if (this.filterType == 12) {
            operator = " overlaps ";
        } else if (this.filterType == 13) {
            operator = " beyond ";
        } else if (this.filterType == 4) {
            operator = " bbox ";
        }
        if (this.leftGeometry == null && this.rightGeometry == null) {
            return "[ null" + operator + "null" + " ]";
        }
        if (this.leftGeometry == null) {
            return "[ null" + operator + this.rightGeometry.toString() + " ]";
        }
        if (this.rightGeometry == null) {
            return "[ " + this.leftGeometry.toString() + operator + "null" + " ]";
        }
        return "[ " + this.leftGeometry.toString() + operator + this.rightGeometry.toString() + " ]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeometryFilterImpl) {
            GeometryFilterImpl geomFilter = (GeometryFilterImpl)((Object)obj);
            boolean isEqual = true;
            isEqual = geomFilter.getFilterType() == this.filterType;
            LOGGER.finest("filter type match:" + isEqual + "; in:" + geomFilter.getFilterType() + "; out:" + this.filterType);
            isEqual = geomFilter.leftGeometry != null ? isEqual && geomFilter.leftGeometry.equals(this.leftGeometry) : isEqual && this.leftGeometry == null;
            LOGGER.finest("left geom match:" + isEqual + "; in:" + geomFilter.leftGeometry + "; out:" + this.leftGeometry);
            isEqual = geomFilter.rightGeometry != null ? isEqual && geomFilter.rightGeometry.equals(this.rightGeometry) : isEqual && this.rightGeometry == null;
            LOGGER.finest("right geom match:" + isEqual + "; in:" + geomFilter.rightGeometry + "; out:" + this.rightGeometry);
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + (this.leftGeometry == null ? 0 : this.leftGeometry.hashCode());
        result = 37 * result + (this.rightGeometry == null ? 0 : this.rightGeometry.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit((GeometryFilter)this);
    }
}

