/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.BBoxExpressionImpl;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.BetweenFilterImpl;
import org.geotools.filter.CartesianDistanceFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.GeometryFilterImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.LogicFilterImpl;
import org.geotools.filter.MathExpression;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.filter.NullFilter;
import org.geotools.filter.NullFilterImpl;

public class FilterFactoryImpl
extends FilterFactory {
    public AttributeExpression createAttributeExpression(FeatureType schema) {
        return new AttributeExpressionImpl(schema);
    }

    public AttributeExpression createAttributeExpression(FeatureType schema, String path) throws IllegalFilterException {
        return new AttributeExpressionImpl(schema, path);
    }

    public BBoxExpression createBBoxExpression(Envelope env) throws IllegalFilterException {
        return new BBoxExpressionImpl(env);
    }

    public BetweenFilter createBetweenFilter() throws IllegalFilterException {
        return new BetweenFilterImpl();
    }

    public CompareFilter createCompareFilter(short type) throws IllegalFilterException {
        return new CompareFilterImpl(type);
    }

    public FidFilter createFidFilter() {
        return new FidFilterImpl();
    }

    public FidFilter createFidFilter(String fid) {
        return new FidFilterImpl(fid);
    }

    public GeometryFilter createGeometryFilter(short filterType) throws IllegalFilterException {
        return new GeometryFilterImpl(filterType);
    }

    public GeometryDistanceFilter createGeometryDistanceFilter(short filterType) throws IllegalFilterException {
        return new CartesianDistanceFilter(filterType);
    }

    public LikeFilter createLikeFilter() {
        return new LikeFilterImpl();
    }

    public LiteralExpression createLiteralExpression() {
        return new LiteralExpressionImpl();
    }

    public LiteralExpression createLiteralExpression(Object o) throws IllegalFilterException {
        return new LiteralExpressionImpl(o);
    }

    public LiteralExpression createLiteralExpression(int i) {
        return new LiteralExpressionImpl(i);
    }

    public LiteralExpression createLiteralExpression(double d) {
        return new LiteralExpressionImpl(d);
    }

    public LiteralExpression createLiteralExpression(String s) {
        return new LiteralExpressionImpl(s);
    }

    public LogicFilter createLogicFilter(short filterType) throws IllegalFilterException {
        return new LogicFilterImpl(filterType);
    }

    public LogicFilter createLogicFilter(Filter filter, short filterType) throws IllegalFilterException {
        return new LogicFilterImpl(filter, filterType);
    }

    public LogicFilter createLogicFilter(Filter filter1, Filter filter2, short filterType) throws IllegalFilterException {
        return new LogicFilterImpl(filter1, filter2, filterType);
    }

    public MathExpression createMathExpression() {
        return new MathExpressionImpl();
    }

    public MathExpression createMathExpression(short expressionType) throws IllegalFilterException {
        return new MathExpressionImpl(expressionType);
    }

    public FunctionExpression createFunctionExpression(String name) {
        int index = -1;
        index = name.indexOf("Function");
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.toLowerCase().trim();
        char c = name.charAt(0);
        name = name.replaceFirst("" + c, "" + Character.toUpperCase(c));
        try {
            return (FunctionExpression)Class.forName("org.geotools.filter." + name + "Function").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create class " + name + "Filter", e);
        }
    }

    public NullFilter createNullFilter() {
        return new NullFilterImpl();
    }
}

