/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterVisitor;

public class FidFilterImpl
extends AbstractFilterImpl
implements FidFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private Set fids = new HashSet();

    protected FidFilterImpl() {
        this.filterType = (short)22;
    }

    protected FidFilterImpl(String initialFid) {
        this.filterType = (short)22;
        this.addFid(initialFid);
    }

    public final void addFid(String fid) {
        LOGGER.finest("got fid: " + fid);
        this.fids.add(fid);
    }

    public boolean contains(Feature feature) {
        if (feature == null) {
            return false;
        }
        return this.fids.contains(feature.getID());
    }

    public String toString() {
        StringBuffer fidFilter = new StringBuffer();
        Iterator fidIterator = this.fids.iterator();
        while (fidIterator.hasNext()) {
            fidFilter.append(fidIterator.next().toString());
            if (!fidIterator.hasNext()) continue;
            fidFilter.append(", ");
        }
        return "[ " + fidFilter.toString() + " ]";
    }

    public boolean equals(Object filter) {
        LOGGER.finest("condition: " + filter);
        if (filter != null && filter.getClass() == ((Object)((Object)this)).getClass()) {
            LOGGER.finest("condition: " + ((FidFilterImpl)((Object)filter)).filterType);
            if (((FidFilterImpl)((Object)filter)).filterType == 22) {
                return ((Object)this.fids).equals(((FidFilterImpl)((Object)filter)).getFidsSet());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.fids).hashCode();
    }

    public String[] getFids() {
        return this.fids.toArray(new String[0]);
    }

    Set getFidsSet() {
        return this.fids;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit((FidFilter)this);
    }
}

