/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import org.geotools.feature.Feature;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.GeometryFilterImpl;
import org.geotools.filter.IllegalFilterException;

public class CartesianDistanceFilter
extends GeometryFilterImpl
implements GeometryDistanceFilter {
    private double distance;

    protected CartesianDistanceFilter(short filterType) throws IllegalFilterException {
        super(filterType);
        if (!CartesianDistanceFilter.isGeometryDistanceFilter((short)filterType)) {
            throw new IllegalFilterException("Attempted to create distance geometry filter with nondistance geometry type.");
        }
        this.filterType = filterType;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean contains(Feature feature) {
        Geometry right = null;
        right = this.rightGeometry != null ? (Geometry)this.rightGeometry.getValue(feature) : feature.getDefaultGeometry();
        Geometry left = null;
        if (this.leftGeometry != null) {
            Object obj = this.leftGeometry.getValue(feature);
            left = (Geometry)obj;
        } else {
            left = feature.getDefaultGeometry();
        }
        if (this.filterType == 13) {
            return !left.isWithinDistance(right, this.distance);
        }
        if (this.filterType == 24) {
            return left.isWithinDistance(right, this.distance);
        }
        return true;
    }

    public String toString() {
        String operator = null;
        if (this.filterType == 13) {
            operator = " beyond ";
        } else if (this.filterType == 24) {
            operator = " dwithin ";
        }
        String distStr = ", distance: " + this.distance;
        if (this.leftGeometry == null && this.rightGeometry == null) {
            return "[ null" + operator + "null" + distStr + " ]";
        }
        if (this.leftGeometry == null) {
            return "[ null" + operator + this.rightGeometry.toString() + distStr + " ]";
        }
        if (this.rightGeometry == null) {
            return "[ " + this.leftGeometry.toString() + operator + "null" + distStr + " ]";
        }
        return "[ " + this.leftGeometry.toString() + operator + this.rightGeometry.toString() + distStr + " ]";
    }

    public boolean equals(Object oFilter) {
        return super.equals(oFilter) && this.distance == this.distance;
    }

    public int hashCode() {
        int result = super.hashCode();
        long bits = Double.doubleToLongBits(this.distance);
        result = 37 * result + (int)(bits ^ bits >>> 32);
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit((GeometryFilter)this);
    }
}

