/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;

public class BetweenFilterImpl
extends CompareFilterImpl
implements BetweenFilter {
    protected Expression middleValue = null;

    protected BetweenFilterImpl() throws IllegalFilterException {
        super((short)19);
    }

    public void addMiddleValue(Expression middleValue) {
        this.middleValue = middleValue;
    }

    public Expression getMiddleValue() {
        return this.middleValue;
    }

    public boolean contains(Feature feature) {
        if (this.middleValue == null) {
            return false;
        }
        double left = ((Number)this.leftValue.getValue(feature)).doubleValue();
        double right = ((Number)this.rightValue.getValue(feature)).doubleValue();
        double mid = ((Number)this.middleValue.getValue(feature)).doubleValue();
        return left <= mid && right >= mid;
    }

    public String toString() {
        return "[ " + this.leftValue.toString() + " < " + this.middleValue.toString() + " < " + this.rightValue.toString() + " ]";
    }

    public boolean equals(Object oFilter) {
        if (oFilter.getClass() == ((Object)((Object)this)).getClass()) {
            BetweenFilterImpl bFilter = (BetweenFilterImpl)((Object)oFilter);
            return bFilter.getFilterType() == this.filterType && bFilter.getLeftValue().equals(this.leftValue) && bFilter.getMiddleValue().equals(this.middleValue) && bFilter.getRightValue().equals(this.rightValue);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.leftValue == null ? 0 : this.leftValue.hashCode());
        result = 37 * result + (this.middleValue == null ? 0 : this.middleValue.hashCode());
        result = 37 * result + (this.rightValue == null ? 0 : this.rightValue.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit((BetweenFilter)this);
    }
}

