/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Iterator;
import java.util.List;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultAttributeType;

public class MultiAttributeType
extends DefaultAttributeType {
    private int maxOccur = 1;
    private AttributeType validator;
    private int minOccur = 1;

    public MultiAttributeType(AttributeType validator) {
        super(validator.getName(), List.class, false, 0, null);
        this.validator = validator;
    }

    public MultiAttributeType(AttributeType validator, int maxOccur) {
        this(validator);
        this.maxOccur = maxOccur;
    }

    public MultiAttributeType(AttributeType validator, int maxOccur, int minOccur) {
        this(validator, maxOccur);
        this.minOccur = minOccur;
    }

    public int getMaxOccurs() {
        return this.maxOccur;
    }

    public int getMinOccurs() {
        return this.minOccur;
    }

    public boolean isGeometry() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void validate(Object attribute) throws IllegalArgumentException {
        super.validate(attribute);
        if (attribute instanceof List) {
            int occurs = ((List)attribute).size();
            if (occurs < this.minOccur) {
                String mesg = "The list of attributes is " + occurs + " long." + "  It must not be less than minOccurs: " + this.minOccur;
                throw new IllegalArgumentException(mesg);
            }
            if (occurs > this.maxOccur) {
                String mesg = "The list of attributes is " + occurs + " long." + "  It must not be greater than maxOccurs: " + this.maxOccur;
                throw new IllegalArgumentException(mesg);
            }
            Iterator iter = ((List)attribute).iterator();
            while (iter.hasNext()) {
                this.validator.validate(iter.next());
            }
        } else {
            String msg = attribute.getClass().getName() + " is not an accetable" + " class for a multiAttributeType.  Must be of type List";
            throw new IllegalArgumentException(msg);
        }
    }

    public Object parse(Object value) throws IllegalArgumentException {
        return value;
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("MultiAttributeType [ ");
        returnString.append("name=").append(this.name).append(',');
        returnString.append("type=").append(this.type.getName()).append(',');
        returnString.append("maxOccurs=").append(this.maxOccur).append(',');
        returnString.append("minOccur=").append(this.minOccur).append(" ]");
        return returnString.toString();
    }
}

