/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.List;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.SchemaException;

public class DefaultFeatureTypeFactory
extends FeatureTypeFactory {
    private List attributeTypes = new ArrayList();

    protected void add(AttributeType type) throws IllegalArgumentException {
        this.attributeTypes.add(type);
    }

    protected void add(int idx, AttributeType type) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        this.attributeTypes.add(idx, type);
    }

    protected FeatureType createFeatureType() throws SchemaException {
        if (this.isAbstract()) {
            return this.createAbstractType();
        }
        return new DefaultFeatureType(this.getName(), this.getNamespace(), this.attributeTypes, this.getSuperTypes(), this.getDefaultGeometry());
    }

    public AttributeType get(int idx) throws ArrayIndexOutOfBoundsException {
        return (AttributeType)this.attributeTypes.get(idx);
    }

    public int getAttributeCount() {
        return this.attributeTypes.size();
    }

    protected AttributeType remove(int idx) throws ArrayIndexOutOfBoundsException {
        return (AttributeType)this.attributeTypes.remove(idx);
    }

    protected AttributeType remove(AttributeType type) {
        if (this.attributeTypes.remove(type)) {
            return type;
        }
        return null;
    }

    protected AttributeType set(int idx, AttributeType type) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        AttributeType former = this.get(idx);
        this.attributeTypes.set(idx, type);
        return former;
    }

    protected FeatureType createAbstractType() throws SchemaException {
        return new DefaultFeatureType.Abstract(this.getName(), this.getNamespace(), this.attributeTypes, this.getSuperTypes(), this.getDefaultGeometry());
    }
}

