/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Collection;
import java.util.Iterator;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeature;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;

public class DefaultFeatureType
implements FeatureType {
    private final String typeName;
    private final String namespace;
    private final AttributeType[] types;
    private final FeatureType[] ancestors;
    private final GeometryAttributeType defaultGeom;
    final int defaultGeomIdx;
    public static final FeatureType EMPTY = new DefaultFeatureType();

    public DefaultFeatureType(String typeName, String namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws SchemaException, NullPointerException {
        if (typeName == null) {
            throw new NullPointerException(typeName);
        }
        this.typeName = typeName;
        this.namespace = namespace == null ? "" : namespace;
        this.types = types.toArray(new AttributeType[types.size()]);
        this.ancestors = superTypes.toArray(new FeatureType[superTypes.size()]);
        this.defaultGeomIdx = this.find((AttributeType)defaultGeom);
        this.defaultGeom = defaultGeom;
    }

    private DefaultFeatureType() {
        this.typeName = "emtpyFeatureType";
        this.namespace = "";
        this.types = new AttributeType[0];
        this.ancestors = new FeatureType[0];
        this.defaultGeomIdx = -1;
        this.defaultGeom = null;
    }

    public Feature create(Object[] attributes) throws IllegalAttributeException {
        return this.create(attributes, null);
    }

    public Feature create(Object[] attributes, String featureID) throws IllegalAttributeException {
        return new DefaultFeature(this, attributes, featureID);
    }

    public Feature duplicate(Feature original) throws IllegalAttributeException {
        if (original == null) {
            return null;
        }
        FeatureType featureType = original.getFeatureType();
        if (!featureType.equals(this)) {
            throw new IllegalAttributeException("Feature type " + featureType + " does not match " + this);
        }
        String id = original.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeType curAttType = this.getAttributeType(i);
            attributes[i] = curAttType.duplicate(original.getAttribute(i));
        }
        return featureType.create(attributes, id);
    }

    public GeometryAttributeType getDefaultGeometry() {
        return this.defaultGeom;
    }

    public AttributeType getAttributeType(String xPath) {
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            if (!this.types[i].getName().equals(xPath)) continue;
            return this.types[i];
        }
        return null;
    }

    public int find(AttributeType type) {
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            if (!this.types[i].equals(type)) continue;
            return i;
        }
        return -1;
    }

    public AttributeType getAttributeType(int position) {
        return this.types[position];
    }

    public AttributeType[] getAttributeTypes() {
        return (AttributeType[])this.types.clone();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    public int getAttributeCount() {
        return this.types.length;
    }

    public boolean equals(FeatureType other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.typeName == null && other.getTypeName() != null) {
            return false;
        }
        if (!this.typeName.equals(other.getTypeName())) {
            return false;
        }
        if (this.namespace == null && other.getNamespace() != null) {
            return false;
        }
        if (!this.namespace.equals(other.getNamespace())) {
            return false;
        }
        if (this.types.length != other.getAttributeCount()) {
            return false;
        }
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            if (this.types[i].equals(other.getAttributeType(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.typeName.hashCode();
        hash *= this.namespace.hashCode();
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            hash *= this.types[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        String info = "name=" + this.typeName;
        info = info + " , namespace=" + this.namespace;
        info = info + " , abstract=" + this.isAbstract();
        String types = "types=(";
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            types = types + this.types[i].toString();
            if (i >= ii) continue;
            types = types + ",";
        }
        types = types + ")";
        info = info + " , " + types;
        return "DefaultFeatureType [" + info + "]";
    }

    public boolean equals(Object other) {
        return this.equals((FeatureType)other);
    }

    public FeatureType[] getAncestors() {
        return this.ancestors;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isDescendedFrom(FeatureType type) {
        return this.isDescendedFrom(type.getNamespace(), type.getTypeName());
    }

    public boolean isDescendedFrom(String nsURI, String typeName) {
        int ii = this.ancestors.length;
        for (int i = 0; i < ii; ++i) {
            if (nsURI != null && !this.ancestors[i].getNamespace().equalsIgnoreCase(nsURI) || !this.ancestors[i].getTypeName().equalsIgnoreCase(typeName)) continue;
            return true;
        }
        return false;
    }

    static final class Abstract
    extends DefaultFeatureType {
        public Abstract(String typeName, String namespace, Collection types, Collection superTypes, GeometryAttributeType defaultGeom) throws SchemaException {
            super(typeName, namespace, types, superTypes, defaultGeom);
            Iterator st = superTypes.iterator();
            while (st.hasNext()) {
                FeatureType ft = (FeatureType)st.next();
                if (ft.isAbstract()) continue;
                throw new SchemaException("Abstract type cannot descend from no abstract type : " + ft);
            }
        }

        public final boolean isAbstract() {
            return true;
        }

        public Feature create(Object[] atts) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Abstract Type");
        }

        public Feature create(Object[] atts, String id) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Abstract Type");
        }
    }
}

