/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Envelope;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;

public class DefaultFeatureCollection
extends AbstractCollection
implements FeatureCollection {
    private Set features = new LinkedHashSet();
    private List listeners = new ArrayList(2);
    private Envelope bounds = null;

    protected DefaultFeatureCollection() {
    }

    public Envelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new Envelope();
            Iterator i = this.features.iterator();
            while (i.hasNext()) {
                Envelope geomBounds = ((Feature)i.next()).getBounds();
                if (geomBounds.isNull()) continue;
                this.bounds.expandToInclude(geomBounds);
            }
        }
        return this.bounds;
    }

    public void addListener(CollectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollectionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange(Feature[] features, int type) {
        this.bounds = null;
        CollectionEvent cEvent = new CollectionEvent((FeatureCollection)this, features, type);
        int ii = this.listeners.size();
        for (int i = 0; i < ii; ++i) {
            ((CollectionListener)this.listeners.get(i)).collectionChanged(cEvent);
        }
    }

    protected void fireChange(Feature feature, int type) {
        this.fireChange(new Feature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        Feature[] features = new Feature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(features, type);
    }

    public boolean add(Object o) {
        Feature feature = (Feature)o;
        boolean changed = this.features.add(feature);
        if (changed) {
            this.fireChange(feature, 0);
        }
        return changed;
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator iter = c.iterator();
        ArrayList<Feature> featuresAdded = new ArrayList<Feature>(c.size());
        while (iter.hasNext()) {
            Feature f = (Feature)iter.next();
            boolean added = this.features.add(f);
            changed |= added;
            if (!added) continue;
            featuresAdded.add(f);
        }
        if (changed) {
            this.fireChange(featuresAdded, 0);
        }
        return changed;
    }

    public void clear() {
        if (this.features.size() == 0) {
            return;
        }
        Feature[] oldFeatures = new Feature[this.features.size()];
        oldFeatures = this.features.toArray(oldFeatures);
        this.features.clear();
        this.fireChange(oldFeatures, 1);
    }

    public boolean contains(Object o) {
        return this.features.contains((Feature)o);
    }

    public boolean isEmpty() {
        return this.features.isEmpty();
    }

    public Iterator iterator() {
        final Iterator iterator = this.features.iterator();
        return new Iterator(){
            Feature currFeature = null;

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                this.currFeature = (Feature)iterator.next();
                return this.currFeature;
            }

            public void remove() {
                iterator.remove();
                DefaultFeatureCollection.this.fireChange(this.currFeature, 1);
            }
        };
    }

    public FeatureIterator features() {
        return new FeatureIterator((FeatureCollection)this);
    }

    public boolean remove(Object o) {
        Feature f = (Feature)o;
        boolean changed = this.features.remove(f);
        if (changed) {
            this.fireChange(f, 1);
        }
        return changed;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator fIter = c.iterator();
        ArrayList<Feature> removedFeatures = new ArrayList<Feature>(c.size());
        while (fIter.hasNext()) {
            Feature f = (Feature)fIter.next();
            boolean removed = this.features.remove(f);
            if (!removed) continue;
            changed = true;
            removedFeatures.add(f);
        }
        if (changed) {
            this.fireChange(removedFeatures, 1);
        }
        return changed;
    }

    public boolean retainAll(Collection c) {
        ArrayList<Feature> removedFeatures = new ArrayList<Feature>(this.features.size() - c.size());
        boolean modified = false;
        Iterator it = this.features.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            if (c.contains(f)) continue;
            it.remove();
            modified = true;
            removedFeatures.add(f);
        }
        if (modified) {
            this.fireChange(removedFeatures, 1);
        }
        return modified;
    }

    public int size() {
        return this.features.size();
    }

    public Object[] toArray() {
        return this.features.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.features.toArray(a);
    }
}

