/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.FeatureLock;
import org.geotools.data.LockingDataSource;
import org.geotools.data.MemoryDataSource;
import org.geotools.data.MemoryLock;
import org.geotools.data.Query;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;

class MemoryLockingDataSource
extends MemoryDataSource
implements LockingDataSource {
    protected Map locks = new HashMap();
    protected Map transactionFeatures;
    protected Map transactionLocks;
    protected Set authorization = new HashSet();
    protected FeatureLock lock = FeatureLock.TRANSACTION;

    protected Map getFeaturesMap() {
        if (this.transactionFeatures != null) {
            return this.transactionFeatures;
        }
        return super.getFeaturesMap();
    }

    protected Map getLocks() {
        return this.transactionLocks != null ? this.transactionLocks : this.locks;
    }

    public void setAutoCommit(boolean autoCommit) throws DataSourceException, UnsupportedOperationException {
        super.setAutoCommit(autoCommit);
        if (autoCommit == this.getAutoCommit()) {
            return;
        }
        if (autoCommit) {
            this.endTransaction();
            this.features = this.transactionFeatures;
            this.locks = this.transactionLocks;
            this.transactionFeatures = null;
            this.transactionLocks = null;
        } else {
            this.transactionFeatures = new HashMap(this.features);
            this.transactionLocks = new HashMap(this.locks);
        }
    }

    public boolean getAutoCommit() throws DataSourceException {
        return super.getAutoCommit() && this.transactionFeatures == null;
    }

    public void commit() throws DataSourceException {
        super.commit();
        if (this.getAutoCommit()) {
            throw new DataSourceException("Commit() requries a transaction");
        }
        this.endTransaction();
        this.features = new HashMap(this.transactionFeatures);
        this.locks = new HashMap(this.transactionLocks);
    }

    public void rollback() throws DataSourceException, UnsupportedOperationException {
        super.rollback();
        if (this.getAutoCommit()) {
            throw new DataSourceException("Rollback requries a transaction");
        }
        this.transactionFeatures = new HashMap(this.features);
        this.transactionLocks = new HashMap(this.locks);
        this.endTransaction();
    }

    protected void endTransaction() {
        this.releaseTransactionLock();
        this.authorization = new HashSet();
        this.lock = FeatureLock.TRANSACTION;
    }

    public void removeFeatures(Filter filter) throws DataSourceException, UnsupportedOperationException {
        super.removeFeatures(filter);
        Set fids = this.getFidSet(this.makeDefaultQuery(filter));
        this.removeFids(fids);
        this.resetBBox();
    }

    public void modifyFeatures(AttributeType[] type, Object[] value, Filter filter) throws DataSourceException, UnsupportedOperationException {
        super.modifyFeatures(type, value, filter);
        Set fids = this.getFidSet(this.makeDefaultQuery(filter));
        this.ensureAuthorization(fids);
        try {
            this.modifyFids(fids, type, value);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not modify.", (Throwable)e);
        }
        this.resetBBox();
    }

    protected void modifyFids(Set fids, AttributeType[] type, Object[] value) throws DataSourceException, ArrayIndexOutOfBoundsException, IllegalAttributeException {
        this.ensureAuthorization(fids);
        Iterator i = fids.iterator();
        while (i.hasNext()) {
            String fid = (String)i.next();
            if (!this.getFeaturesMap().containsKey(fid)) continue;
            Feature feature = (Feature)this.getFeaturesMap().get(fid);
            this.modifyFeature(feature, type, value);
        }
    }

    protected void modifyFeature(Feature feature, AttributeType[] type, Object[] value) throws IllegalAttributeException {
        int i;
        FeatureType featureType = feature.getFeatureType();
        int[] index = new int[type.length];
        for (i = 0; i < type.length; ++i) {
            index[i] = featureType.find(type[i]);
            if (index[i] == -1) {
                throw new IllegalAttributeException("Could not find " + type[i].getName());
            }
            type[i].validate(value[i]);
        }
        for (i = 0; i < type.length; ++i) {
            feature.setAttribute(index[i], value[i]);
        }
    }

    public void setFeatures(FeatureCollection collection) throws DataSourceException, UnsupportedOperationException {
        super.setFeatures(collection);
        this.ensureAuthorization();
        this.getFeaturesMap().clear();
        this.addFeatures(collection);
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport memMeta = new AbstractDataSource.MetaDataSupport();
        memMeta.setSupportsAdd(true);
        memMeta.setFastBbox(true);
        memMeta.setSupportsRemove(true);
        memMeta.setSupportsModify(true);
        memMeta.setSupportsGetBbox(true);
        memMeta.setSupportsSetFeatures(true);
        memMeta.setSupportsRollbacks(true);
        return memMeta;
    }

    public Envelope getBounds() throws DataSourceException, UnsupportedOperationException {
        super.getBounds();
        return this.calculateBBox();
    }

    protected Envelope calculateBBox() {
        Envelope newBBox = new Envelope();
        Iterator i = this.getFeaturesMap().values().iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            Envelope internal = feature.getDefaultGeometry().getEnvelopeInternal();
            newBBox.expandToInclude(internal);
        }
        return newBBox;
    }

    protected void resetBBox() {
        this.bbox = this.calculateBBox();
    }

    protected void removeFids(Set fids) throws DataSourceException {
        this.ensureAuthorization(fids);
        Iterator i = fids.iterator();
        while (i.hasNext()) {
            String fid = (String)i.next();
            this.getFeaturesMap().remove(fid);
            this.getLocks().remove(fid);
        }
    }

    public void setFeatureLock(FeatureLock featureLock) {
        if (featureLock == null) {
            throw new NullPointerException("FeatureLock required");
        }
        this.lock = featureLock;
    }

    public int lockFeatures(Query query) throws DataSourceException {
        return this.lockFidsSet(this.getFidSet(query));
    }

    public int lockFeatures(Filter filter) throws DataSourceException {
        return this.lockFeatures(this.makeDefaultQuery(filter));
    }

    public int lockFeatures() throws DataSourceException {
        return this.lockFeatures(Query.ALL);
    }

    public void setAuthorization(Set authIDs) {
        this.authorization = new HashSet();
        if (authIDs == null || authIDs.size() == 0) {
            return;
        }
        this.authorization.addAll(authIDs);
    }

    public void setAuthorization(String authID) {
        this.setAuthorization(Collections.singleton(authID));
    }

    public void unLockFeatures() throws DataSourceException {
        this.unLockFeatures(Query.ALL);
    }

    public void unLockFeatures(Filter filter) throws DataSourceException {
        this.unLockFeatures(this.makeDefaultQuery(filter));
    }

    public void unLockFeatures(Query query) throws DataSourceException {
        this.unLockFidSet(this.getFidSet(query));
    }

    public void refreshLock(String authID) throws DataSourceException {
        if (!this.authorization.contains(authID)) {
            throw new DataSourceException("Not authorized to refresh " + authID);
        }
        HashSet locks = new HashSet(this.getLocks().values());
        Iterator i = locks.iterator();
        while (i.hasNext()) {
            MemoryLock memoryLock = (MemoryLock)i.next();
            if (!authID.equals(memoryLock.authID)) continue;
            memoryLock.refresh();
        }
    }

    public void releaseLock(String authID) throws DataSourceException {
        if (!this.authorization.contains(authID)) {
            throw new DataSourceException("Not authorized to release " + authID);
        }
        HashSet locks = new HashSet(this.getLocks().values());
        Iterator i = locks.iterator();
        while (i.hasNext()) {
            MemoryLock memoryLock = (MemoryLock)i.next();
            if (authID.equals(memoryLock.authID)) continue;
            i.remove();
        }
        this.releaseLocks(locks);
    }

    public void releaseTransactionLock() {
        this.releaseLock(MemoryLock.CURRENT_TRANSACTION);
    }

    protected int lockFidsSet(Set fids) throws DataSourceException {
        if (this.lock == FeatureLock.TRANSACTION && this.getAutoCommit()) {
            throw new DataSourceException("Cannot lock features without either a transaction or FeatureLock.");
        }
        if (fids.isEmpty()) {
            return 0;
        }
        int count = 0;
        MemoryLock memoryLock = this.createMemoryLock(this.lock);
        Iterator i = fids.iterator();
        while (i.hasNext()) {
            String fid = (String)i.next();
            if (this.isLocked(fid)) continue;
            this.getLocks().put(fid, memoryLock);
            ++count;
        }
        return count;
    }

    protected void unLockFidSet(Set fids) throws DataSourceException {
        this.ensureAuthorization(fids);
        this.getLocks().keySet().removeAll(fids);
    }

    protected void ensureUnLocked(Set fids) throws DataSourceException {
        Iterator i = fids.iterator();
        while (i.hasNext()) {
            this.ensureUnLocked((String)i.next());
        }
    }

    protected void ensureUnLocked(String fid) throws DataSourceException {
        MemoryLock memoryLock = this.getMemoryLock(fid);
        if (memoryLock == null) {
            return;
        }
        throw new DataSourceException("Feature (FID " + fid + ") " + "was Locked with " + memoryLock.authID);
    }

    protected void ensureAuthorization() throws DataSourceException {
        HashSet locks = new HashSet(this.getLocks().values());
        Iterator i = locks.iterator();
        while (i.hasNext()) {
            MemoryLock memoryLock = (MemoryLock)i.next();
            if (memoryLock.isAuthorized(this.authorization)) continue;
            throw new DataSourceException("Not authorized with " + memoryLock.authID);
        }
    }

    protected void ensureAuthorization(Set fids) throws DataSourceException {
        Iterator i = fids.iterator();
        while (i.hasNext()) {
            this.ensureAuthorization((String)i.next());
        }
    }

    protected void ensureAuthorization(String fid) throws DataSourceException {
        MemoryLock memoryLock = this.getMemoryLock(fid);
        if (memoryLock == null) {
            return;
        }
        if (memoryLock == MemoryLock.CURRENT_TRANSACTION) {
            return;
        }
        if (memoryLock.isAuthorized(this.authorization)) {
            return;
        }
        throw new DataSourceException("Authorization Required for Feature (FID " + fid + ") " + "require " + memoryLock.authID);
    }

    protected Set authorizedSet(Set fids) {
        HashSet<String> authorized = new HashSet<String>();
        Iterator i = fids.iterator();
        while (i.hasNext()) {
            String fid = (String)i.next();
            if (!this.isAuthorized(fid)) continue;
            authorized.add(fid);
        }
        return authorized;
    }

    protected boolean isAuthorized(String fid) {
        MemoryLock memoryLock = this.getMemoryLock(fid);
        if (memoryLock == null) {
            return true;
        }
        if (memoryLock == MemoryLock.CURRENT_TRANSACTION) {
            return true;
        }
        return memoryLock.isAuthorized(this.authorization);
    }

    protected boolean isLocked(String fid) {
        return this.getMemoryLock(fid) != null;
    }

    protected String lockStatus(String fid) {
        MemoryLock memoryLock = null;
        if (this.getLocks().containsKey(fid)) {
            memoryLock = (MemoryLock)this.getLocks().get(fid);
            if (memoryLock == MemoryLock.CURRENT_TRANSACTION) {
                return "Transaction Lock";
            }
            return memoryLock.toString();
        }
        return "Not Locked";
    }

    protected String locksStatus() {
        if (this.getLocks().isEmpty()) {
            return "No Locks Held";
        }
        StringBuffer buffer = new StringBuffer(this.getLocks().size() + " Locks Held");
        Iterator i = this.getLocks().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            buffer.append("\n");
            buffer.append(entry.getKey());
            buffer.append("=");
            buffer.append(entry.getValue());
        }
        return buffer.toString();
    }

    protected MemoryLock getMemoryLock(String fid) {
        if (!this.getLocks().containsKey(fid)) {
            return null;
        }
        MemoryLock memoryLock = (MemoryLock)this.getLocks().get(fid);
        if (memoryLock.isExpired()) {
            this.releaseLock(memoryLock);
            return null;
        }
        return memoryLock;
    }

    protected void releaseExpiredLocks() {
        HashSet locks = new HashSet(this.getLocks().values());
        Iterator i = locks.iterator();
        while (i.hasNext()) {
            MemoryLock memoryLock = (MemoryLock)i.next();
            if (memoryLock.isExpired()) continue;
            i.remove();
        }
        this.releaseLocks(locks);
    }

    protected void releaseLocks(Set memoryLocks) {
        this.getLocks().values().removeAll(memoryLocks);
    }

    protected void releaseLock(MemoryLock memoryLock) {
        this.releaseLocks(Collections.singleton(memoryLock));
    }

    protected Set getFidSet(Query query) throws DataSourceException {
        HashSet<String> set = new HashSet<String>();
        FeatureCollection features = this.getFeatures(query);
        FeatureIterator iterator = features.features();
        while (iterator.hasNext()) {
            Feature feature = iterator.next();
            set.add(feature.getID());
        }
        return set;
    }

    protected MemoryLock createMemoryLock(FeatureLock featureLock) {
        if (featureLock == FeatureLock.TRANSACTION) {
            return MemoryLock.CURRENT_TRANSACTION;
        }
        return new MemoryLock(featureLock);
    }
}

