/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.Set;
import org.geotools.data.FeatureLock;

class MemoryLock {
    static final MemoryLock CURRENT_TRANSACTION = new MemoryLock("CURRENT_TRANSACTION", 0L);
    String authID;
    long duration;
    long expiry;

    public MemoryLock(FeatureLock featureLock) {
        this(featureLock.getAuthorization(), featureLock.getDuration());
    }

    protected MemoryLock(String id, long length) {
        this.authID = id;
        this.duration = length;
        this.expiry = System.currentTimeMillis() + length;
    }

    public void refresh() {
        this.expiry = System.currentTimeMillis() + this.duration;
    }

    public boolean isExpired() {
        if (this.duration == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return now >= this.expiry;
    }

    public boolean isAuthorized(Set authorization) {
        return authorization.contains(this.authID);
    }

    public String toString() {
        if (this.duration == 0L) {
            return "MemoryLock(" + this.authID + "|PermaLock)";
        }
        long now = System.currentTimeMillis();
        long delta = this.expiry - now;
        long dur = this.duration;
        return "MemoryLock(" + this.authID + "|" + delta + "ms|" + dur + "ms)";
    }
}

